function Mout=prinCompLumScaleW(M,CSV,mu)
% 
% clear all
% close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%   Principal Components Method -- scaled to have results between 0 and 1
%   WITH windowing
%   Grayscale output with 3x replicated frames
%   M is the output of RGBread
%   CSV=csvread('subject50.csv');
%   mu is the multiplication factor by which the output luminance is
%   multiplied.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%% Set Parameters %%%%%%%%%%%%%%%%%
[HEIGHT,WIDTH,FRAMES] = size(M);

%%%%% Defining the windows for the eyes and the mouth

rightEyeX=CSV(1:FRAMES/3,12);
rightEyeY=CSV(1:FRAMES/3,13);
leftEyeX=CSV(1:FRAMES/3,14);
leftEyeY=CSV(1:FRAMES/3,15);

widthEye=leftEyeX-rightEyeX;

eyeWindowX=[rightEyeX-floor(widthEye/2) leftEyeX+floor(widthEye/2)];
eyeWindowY=[min([leftEyeY';rightEyeY'])'-floor(widthEye/2) max([leftEyeY';rightEyeY'])'+floor(widthEye/2)];

rightMouthX=CSV(1:FRAMES/3,20);
rightMouthY=CSV(1:FRAMES/3,21);
leftMouthX=CSV(1:FRAMES/3,22);
leftMouthY=CSV(1:FRAMES/3,23);

widthMouth=leftMouthX-rightMouthX;

mouthWindowX=[rightMouthX-floor(widthMouth/2) leftMouthX+floor(widthMouth/2)];
mouthWindowY=[min([leftMouthY';rightMouthY'])'-floor(widthMouth/2) max([leftMouthY';rightMouthY'])'+floor(widthMouth/2)];

%%%%%% Generating the videos %%%%%%%%%%%%%%%%

maxVar=zeros(HEIGHT,WIDTH,FRAMES/3);
DEF_WINDOW_E=0;
DEF_WINDOW_M=0;

for i=1:FRAMES/3 

%%%%%% Maximum Variance Projection   %%%%%%%%%

    [X,R] = imstack2vectors(double(M(:,:,3*(i-1)+1:3*i)));
    P = princomp(X, 3);
    F=reshape(P.Y(:,1), HEIGHT, WIDTH);
    maxVar(:,:,i)=(F-min(F(:)))/(max(F(:)-min(F(:))));

    if i>1
        if (rightEyeX(i-1)>0 && rightEyeY(i-1)>0 && leftEyeX(i-1)>0 && leftEyeY(i-1)>0)
        
        DEF_WINDOW_E=1;
        IE=i;
        eyeWindow=M(eyeWindowY(i-1,1):eyeWindowY(i-1,2),eyeWindowX(i-1,1):eyeWindowX(i-1,2),3*(i-1)+1:3*i);
        
        
        [EX,R] = imstack2vectors(eyeWindow);
        EP = princomp(EX, 3);
        EF=reshape(EP.Y(:,1), size(eyeWindow,1), size(eyeWindow,2));
        eyeWmv=(EF-min(EF(:)))/(max(EF(:)-min(EF(:))));
        eyeWmv=min(mu*eyeWmv,ones(size(eyeWindow,1), size(eyeWindow,2)));
        
        end
        
        if (rightMouthX(i-1)>0 && rightMouthY(i-1)>0 && leftMouthX(i-1)>0 && leftMouthY(i-1)>0)
        
        DEF_WINDOW_M=1;
        IM=i;
        mouthWindow=M(mouthWindowY(i-1,1):mouthWindowY(i-1,2),mouthWindowX(i-1,1):mouthWindowX(i-1,2),3*(i-1)+1:3*i);
        
        [MX,R] = imstack2vectors(mouthWindow);
        MP = princomp(MX, 3);
        MF=reshape(MP.Y(:,1), size(mouthWindow,1), size(mouthWindow,2));
        mouthWmv=(MF-min(MF(:)))/(max(MF(:)-min(MF(:))));
        mouthWmv=min(mu*mouthWmv,ones(size(mouthWindow,1), size(mouthWindow,2)));
        
        end
        
        if DEF_WINDOW_E
           maxVar(eyeWindowY(IE-1,1):eyeWindowY(IE-1,2),eyeWindowX(IE-1,1):eyeWindowX(IE-1,2),i)=eyeWmv;
        end
    
         if DEF_WINDOW_M    
            maxVar(mouthWindowY(IM-1,1):mouthWindowY(IM-1,2),mouthWindowX(IM-1,1):mouthWindowX(IM-1,2),i)=mouthWmv;
    	end
        
    end
    
    
end

%%%% Output videos %%%%%%%%%%%%%%%%%%%%%

% maxVar=reshape([maxVar maxVar maxVar],HEIGHT,FRAMES*WIDTH);
% maxVar=reshape(maxVar,HEIGHT,WIDTH,FRAMES);

Mout=maxVar;
end