function y=luminanceScale(image, NbOutputs)



 % load rgb images

 Im =double(imread(image));

 

 % rgb -> grayscale coefficients. We can also try to modify them

 rgb2gray=[ .299 .587 .114 ];

 

 % Convert to grayscale and evaluating mean luminance

 [m,n,p]=size(Im);

 L=0;

 ImGray=zeros(m,n);

 

 for i=1:m

     for j=1:n

      rgb(1:3)=Im(i,j,1:3);

      ImGray(i,j)=floor(rgb*rgb2gray');

     end

 end

 

 Lmean=mean(mean(ImGray));

 

 step=255/(NbOutputs-1);

 

 pathdir=['Output_' image];

 

 mkdir(pathdir);

 cd(pathdir);

 map=colormap(gray(256));

 

 L=0:step:255;

 for i=1:length(L)

     ImCopy=ImGray;

     ImCopy=min(ImCopy*L(i)/Lmean,255);

     l=mean(mean(ImCopy));

     path=['luminance' int2str(floor(l)) '.tif'];

     imwrite(ImCopy,map,path,'tiff');

 end

 y=Lmean;

 cd ..

 end