function Mout=grayScaleSCW(M,CSV)

clear all
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%   GrayScale method -- scaled so that each frame ranges from 0 to 1
%   WITH windowing
%   Grayscale output with 3x replicated frames
%   M is the output of RGBread
%   CSV=csvread('subject50.csv');
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%% Set Parameters %%%%%%%%%%%%%%%%%
[HEIGHT,WIDTH,FRAMES] = size(M);

%%%%% Defining the windows for the eyes and the mouth

rightEyeX=CSV(1:FRAMES/3,12);
rightEyeY=CSV(1:FRAMES/3,13);
leftEyeX=CSV(1:FRAMES/3,14);
leftEyeY=CSV(1:FRAMES/3,15);

widthEye=leftEyeX-rightEyeX;

eyeWindowX=[rightEyeX-floor(widthEye/2) leftEyeX+floor(widthEye/2)];
eyeWindowY=[min([leftEyeY';rightEyeY'])'-floor(widthEye/2) max([leftEyeY';rightEyeY'])'+floor(widthEye/2)];

rightMouthX=CSV(1:FRAMES/3,20);
rightMouthY=CSV(1:FRAMES/3,21);
leftMouthX=CSV(1:FRAMES/3,22);
leftMouthY=CSV(1:FRAMES/3,23);

widthMouth=leftMouthX-rightMouthX;

mouthWindowX=[rightMouthX-floor(widthMouth/2) leftMouthX+floor(widthMouth/2)];
mouthWindowY=[min([leftMouthY';rightMouthY'])'-floor(widthMouth/2) max([leftMouthY';rightMouthY'])'+floor(widthMouth/2)];

%%%%%% Generating the videos %%%%%%%%%%%%%%%%

gScale=zeros(HEIGHT,WIDTH,FRAMES/3);

for i=1:FRAMES/3 

%%%%%% GrayScaling   %%%%%%%%%

    F=double(rgb2gray(M(:,:,3*(i-1)+1:3*i)));
    gScale(:,:,i)=(F-min(F(:)))/(max(F(:))-min(F(:)));

    if i>1
        if eyeWindowY(i-1,1)>0
        
        eyeWindow=M(eyeWindowY(i-1,1):eyeWindowY(i-1,2),eyeWindowX(i-1,1):eyeWindowX(i-1,2),3*(i-1)+1:3*i);
        mouthWindow=M(mouthWindowY(i-1,1):mouthWindowY(i-1,2),mouthWindowX(i-1,1):mouthWindowX(i-1,2),3*(i-1)+1:3*i);
        
        EF=double(rgb2gray(eyeWindow));
        eyeWsg=(EF-min(EF(:)))/(max(EF(:))-min(EF(:)));
        
        MF=double(rgb2gray(mouthWindow));
        mouthWsg=(MF-min(MF(:)))/(max(MF(:))-min(MF(:)));

        end
        
        gScale(eyeWindowY(i-1,1):eyeWindowY(i-1,2),eyeWindowX(i-1,1):eyeWindowX(i-1,2),i)=eyeWmv;
        gScale(mouthWindowY(i-1,1):mouthWindowY(i-1,2),mouthWindowX(i-1,1):mouthWindowX(i-1,2),i)=mouthWmv;
        
    end
    
    
end

%%%% Output file %%%%%%%%%%%%%%%%%%%%%
gScale=reshape([gScale gScale gScale],HEIGHT,FRAMES*WIDTH);
gScale=reshape(maxVar,HEIGHT,WIDTH,FRAMES);

Mout=gScale;
end