function Mout=grayScaleSCNW(M)

% clear all
% close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%   GrayScale method -- scaled so that each frame ranges from 0 to 1
%   WITHOUT windowing
%   Grayscale output with 3x replicated frames
%   M is the output of RGBread
%   CSV=csvread('subject50.csv');
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%% Set Parameters %%%%%%%%%%%%%%%%%
[HEIGHT,WIDTH,FRAMES] = size(M);

%%%%%% Generating the videos %%%%%%%%%%%%%%%%

gScale=zeros(HEIGHT,WIDTH,FRAMES/3);

for i=1:FRAMES/3 

%%%%%% GrayScaling   %%%%%%%%%

    F=double(rgb2gray(M(:,:,3*(i-1)+1:3*i)));
    gScale(:,:,i)=(F-min(F(:)))/(max(F(:))-min(F(:)));
    
end

%%%% Output file %%%%%%%%%%%%%%%%%%%%%
% gScale=reshape([gScale gScale gScale],HEIGHT,FRAMES*WIDTH);
% gScale=reshape(maxVar,HEIGHT,WIDTH,FRAMES);

Mout=gScale;
end