% INPUT: Number of frames to convert:
nFrames = 75;

% Declaring output matrix:
YEqualizedFrames = zeros(size(M));

% Performing luminance equalization of each frame:
for i = 1 : nFrames
    
    % Convert current frame into luminance (YCbCr):
    MY = rgb2ycbcr(M(:,:, 3*(i-1)+1 : 3*(i-1)+3));
    
    % Equalizing the luminance component:
    MY(:,:,1) = histeq(MY(:,:,1));
    
    YEqualizedFrames(:,:, 3*(i-1)+1 : 3*(i-1)+3) = ycbcr2rgb(MY);
end

% RESULT: YEqualizedFrames
YEqualizedFrames = uint8(YEqualizedFrames);
makeMovie(strcat('YEqualizeMethod', subject), YEqualizedFrames);
clear YEqualizedFrames