% Generating sample squares:
sample = zeros(640,640,3);
sample(:,:,1) = 120;
sample(:,:,2) = 0;
sample(:,:,3) = 120;
sample(1:160, 1:160, 2) = 0;
sample(161:320, 1:160, 2) = 20;
sample(321:480, 1:160, 2) = 40;
sample(481:640, 1:160, 2) = 60;
sample(1:160, 161:320, 2) = 80;
sample(1:160, 321:480, 2) = 100;
sample(1:160, 481:640, 2) = 120;
sample(161:320, 161:320, 2) = 140;
sample(161:320, 321:480, 2) = 160;
sample(161:320, 481:640, 2) = 180;
sample(321:480, 321:480, 2) = 200;
sample(321:480, 321:480, 2) = 220;
sample(321:480, 481:640, 2) = 220;
sample(321:480, 481:640, 2) = 240;
sample(481:640, 161:320, 2) = 30;
sample(481:640, 321:480, 2) = 130;
sample(481:640, 481:640, 2) = 255;
sample(1:320, 1:320, 3) = 20;
sample(321:640, 1:320, 3) = 120;
sample(321:640, 321:640, 3) = 220;
sample(321:640, 1:320, 3) = 66;
sample(321:640, 1:320, 3) = 166;
sample(1:320, 1:320, 3) = 250;
sample = sample./max(sample(:));

% Converting from YCbCr to RGB:
RGB = ycbcr2rgb(sample);
imshow(RGB);
edges = edge(rgb2gray(RGB), 'sobel', 0.001, 'both'); imshow(edges);

% Principal component analysis (see Dikbas paper):
S = cat(3, RGB(:,:,1), RGB(:,:,2), RGB(:,:,3));
[X,R] = imstack2vectors(S);
P = princomp(X, 3);
prin1 = reshape(P.Y(:,1), 640, 640);
prin2 = reshape(P.Y(:,2), 640, 640);
prin3 = reshape(P.Y(:,3), 640, 640);
edgeP = edge(prin1, 'sobel', 0.001, 'both'); imshow(edgeP);

% Color gradient and Laplacian method:
[VG, A, PPG] = colorgrad(RGB);
edgeGrad = edge(VG, 'sobel', 0.001, 'both'); imshow(edgeGrad);
edgeGrad = edge(PPG, 'sobel', 0.001, 'both'); imshow(edgeGrad);
