% Eigenimage edge enhancement:
M = RGBread('subject50.v',640, 480, 100);

% Eigenimages of the first frame:
S = cat(3, M(:,:,1), M(:,:,2), M(:,:,3));
[X,R] = imstack2vectors(S);
P = princomp(X, 3);
prin1 = reshape(P.Y(:,1), size(M,1), size(M,2));
prin2 = reshape(P.Y(:,2), size(M,1), size(M,2));
prin3 = reshape(P.Y(:,3), size(M,1), size(M,2));
prin(:,:,1) = prin1;
prin(:,:,2) = prin2;
prin(:,:,3) = prin3;

% Converting from eigenimages to RGB:
prinRGB = ycbcr2rgb(prin);

% Converting to YCbCr:
prinY = rgb2ycbcr(prinRGB); prinY = prinY(:,:,1);
edgeP = edge(rgb2gray(prinRGB), 'sobel', 0.3, 'both'); figure; imshow(edgeP);
MY = rgb2ycbcr(M(:,:,1:3));

% Enhancing edges from principal contrast image:
edgeim = uint8(double(MY(:,:,1)) + prin1);
edgeP = edge(edgeim, 'sobel', 0.2, 'both'); figure; imshow(edgeP);
M2 = MY;
M2(:,:,1) = edgeim;

% Converting to RGB:
mRGB = ycbcr2rgb(M2); 

% mRGB is the result!!!!

% -------------------------------------------------------------------------

% Histogram equalization:
MY = rgb2ycbcr(M(:,:,1:3));
M2 = MY;

% Equalizing the luminance histogram:
M2(:,:,1) = histeq(MY(:,:,1));
mRGB = ycbcr2rgb(M2);

% mRGB is the result!!!!

% -------------------------------------------------------------------------

% Equalizing the RGB histograms:
M3(:,:,3) = histeq(M(:,:,3));
M3(:,:,2) = histeq(M(:,:,2));
M3(:,:,1) = histeq(M(:,:,1));

% M3 is the result!!!!

% -------------------------------------------------------------------------


