function M = RGBread(name, width, height, frames)

% RGBREAD read video in RGB24 format
%
%   M = RGBread(name, width, height, frames)
%
%   name   : name of RGB file
%   width  : width of frame
%   height : height of frame
%   frames : number of frames
%   R      : array of R frames
%   G      : array of G frames
%   B      : array of B frames
%


fid = fopen(name, 'r');
if(fid == -1)
 disp(['RGBread: cannot open file: ' name]);
 R=0; G=0; B=0;
 return;
end;

 R = uint8(zeros(height, width, frames));
 G = uint8(zeros(height, width, frames));
 B = uint8(zeros(height, width, frames));
 M = uint8(zeros(height, width, frames*3));

 for i = 1:frames
 RGB=fread(fid, [ 3,width*height ], 'uint8');
 R= (reshape(RGB(1,:), width, height))'; G =( reshape(RGB(2,:), width,height))'; B =( reshape(RGB(3,:), width,height))';
  M(:,:,3*(i-1)+1)=R;
  M(:,:,3*(i-1)+2)=G;
  M(:,:,3*(i-1)+3)=B;
 end

 fclose(fid);
end