
load masks.mat;

B = bwlabel(mask);
bb = regionprops(B, 'BoundingBox', 'ConvexImage');
bb = [bb.BoundingBox];
startRow = round(bb(2)); 
endRow = startRow + round(bb(4)) - 1;
startCol = round(bb(1));
endCol = startCol + round(bb(3)) - 1;
X = [startCol endCol endCol startCol];
Y = [startRow startRow endRow endRow];

maskedImage = M(Y(1):Y(4), X(1):X(2), 1:3);

maskedR = maskedImage(:,:,1);
maskedG = maskedImage(:,:,2);
maskedB = maskedImage(:,:,3);

equalizedR = histeq(maskedR);
equalizedG = histeq(maskedG);
equalizedB = histeq(maskedB);
equalized = cat(3, equalizedR, equalizedG, equalizedB);
% Here is one intermediate result.

h1 = hist(double(equalizedR(:)), 256);
h2 = hist(double(equalizedG(:)), 256);
h3 = hist(double(equalizedB(:)), 256);

eq = M(:,:,1:3);
eq(:,:,1) = histeq(M(:,:,1), h1);
eq(:,:,2) = histeq(M(:,:,2), h2);
eq(:,:,3) = histeq(M(:,:,3), h3);
imshow(eq)
% ^^^ Equalized


eq(:,:,1) = histeq(M(:,:,1), hist(double(maskedR(:))));
eq(:,:,2) = histeq(M(:,:,2), hist(double(maskedG(:))));
eq(:,:,3) = histeq(M(:,:,3), hist(double(maskedB(:))));
imshow(eq)
% ^^ All Brown

eq(:,:,1) = histeq(eq(:,:,1));
eq(:,:,2) = histeq(eq(:,:,2));
eq(:,:,3) = histeq(eq(:,:,3));
imshow(eq)
% ^^ Browns maximally stretched.
