
% INPUT: Number of frames to convert:
nFrames = 75;

% Declaring output matrix:
eigenFrames = zeros(size(M));

% Eigenimages of each frame:
for i = 1 : nFrames
    S = cat(3, M(:,:,3*(i-1)+1), M(:,:,3*(i-1)+2), M(:,:,3*(i-1)+3));
    [X,R] = imstack2vectors(S);
    P = princomp(X, 3);
    prin1 = reshape(P.Y(:,1), size(M,1), size(M,2));
    
    % Convert current frame into luminance (YCbCr):
    MY = rgb2ycbcr(M(:,:, 3*(i-1)+1 : 3*(i-1)+3));
    
    % Enhancing luminance edges from principal contrast image:
    boostedImage = double(MY(:,:,1)) + prin1;
    boostedImage = boostedImage./max(boostedImage(:)) * 255;
    
    MY(:,:,1) = uint8(boostedImage);
    eigenFrames(:,:, 3*(i-1)+1 : 3*(i-1)+3) = ycbcr2rgb(MY);
end

% RESULT: eigenFrames

% ------------------------------------------------------------------------
eigenFrames = uint8(eigenFrames);
makeMovie(strcat('EigenMethod', subject), eigenFrames);
clear eigenFrames