
% INPUT: Number of frames to convert:
nFrames = 75;

% Declaring output matrix:
%gradFrames = zeros(size(M));
lapFrames = zeros(size(M));

% Color gradient of each frame:
for i = 1 : nFrames
     
    % Current frame extraction:
    Mrgb = (M(:,:, 3*(i-1)+1 : 3*(i-1)+3));
    MY = rgb2ycbcr(Mrgb);
    [VG, A, PPG] = colorgrad(Mrgb);
    
    % Enhancing luminance edges from color gradient:
    boostedImage = double(MY(:,:,1)) + 200*VG;
    boostedImage = boostedImage./max(boostedImage(:)) * 255;
    
    % Enhancing edges in all colors via PPG:
    boostR = double(Mrgb(:,:,1)) + 255*PPG;
    boostG = double(Mrgb(:,:,2)) + 255*PPG;
    boostB = double(Mrgb(:,:,3)) + 255*PPG;
    boostR = uint8(boostR./max(boostR(:)) * 255);
    boostG = uint8(boostG./max(boostG(:)) * 255);
    boostB = uint8(boostB./max(boostB(:)) * 255);
    Mboosted = cat(3, histeq(boostR), histeq(boostG), histeq(boostB));
    
    MY(:,:,1) = uint8(boostedImage);
    
    %gradFrames(:,:, 3*(i-1)+1 : 3*(i-1)+3) = (ycbcr2rgb(MY));
    lapFrames(:,:, 3*(i-1)+1 : 3*(i-1)+3) = (Mboosted);
end

% Casting results as UINT8 (MARIA! CHANGE HERE IF BUGS ARISE):
%gradFrames = uint8(gradFrames);
% makeMovie(strcat('colorGrad', subject), gradFrames);
% clear gradFrames
lapFrames = uint8(lapFrames);
makeMovie(strcat('colorGradMBoosted', subject), lapFrames);
clear lapFrames
% RESULT: gradFrames and lapFrames

% -------------------------------------------------------------------------




