#include <avr/io.h>
#include "lm75.h"
#include "twi.h"


//------------------------------------------
//  Do stuff on I2C interface
//------------------------------------------
char TWI_action(char command)
{
  TWCR = (command | (1 << TWINT));                //command to TWCR force TWINT 
  while (!(TWCR & (1 <<TWINT)));              //Wait for TWINT
  return TWSR;
}

//------------------------------------------
//  Read temperature from LM75 at addr 9E
//------------------------------------------
signed char read_temp0(void)
{
  signed char tmp1;
  unsigned char tmp2;
  TWI_action((1<<TWINT)|(1<<TWSTA)|(1<<TWEN));// Start the I2C 
  TWDR = 0x90;                                              	// Slave Address WRITE 
  TWI_action((1<<TWINT)|(1<<TWEN));                 
  TWDR = 0x00;                                              	// LM75 Command 
  TWI_action((1<<TWINT)|(1<<TWEN));
  TWI_action((1<<TWINT)|(1<<TWSTA)|(1<<TWEN));// Repeated start 
  TWDR = 0x91;                                              	// Slave Adres READ (+1)
  TWI_action((1<<TWINT)|(1<<TWEN));
  TWI_action((1<<TWINT)|(1<<TWEN)|(1<<TWEA)); // Enabe Ack  1st Byte=get 2nd
  tmp1=TWDR;
  TWI_action((1<<TWINT)|(1<<TWEN));                 // No ack bit here
  tmp2=TWDR;
  TWCR = ((1<<TWINT)|(1<<TWSTO)|(1<<TWEN));   // Stop the I2C train
  
//   if(tmp2&0x80) halfdegree=1;            // check if half degree is present
//   else halfdegree=0;                     // or not
	return tmp1;
}
signed char read_temp1(void)
{
  signed char tmp1;
  unsigned char tmp2;
  TWI_action((1<<TWINT)|(1<<TWSTA)|(1<<TWEN));// Start the I2C 
  TWDR = 0x92;                                              	// Slave Address WRITE 
  TWI_action((1<<TWINT)|(1<<TWEN));                 
  TWDR = 0x00;                                              	// LM75 Command 
  TWI_action((1<<TWINT)|(1<<TWEN));
  TWI_action((1<<TWINT)|(1<<TWSTA)|(1<<TWEN));// Repeated start 
  TWDR = 0x93;                                              	// Slave Adres READ (+1)
  TWI_action((1<<TWINT)|(1<<TWEN));
  TWI_action((1<<TWINT)|(1<<TWEN)|(1<<TWEA)); // Enabe Ack  1st Byte=get 2nd
  tmp1=TWDR;
  TWI_action((1<<TWINT)|(1<<TWEN));                 // No ack bit here
  tmp2=TWDR;
  TWCR = ((1<<TWINT)|(1<<TWSTO)|(1<<TWEN));   // Stop the I2C train
  
//   if(tmp2&0x80) halfdegree=1;            // check if half degree is present
//   else halfdegree=0;                     // or not
	return tmp1;
}





unsigned short ReadTemp(unsigned char sensor)
{

//LM75 slave address is 0x48 + pin-selected address

	unsigned short temp;
	//We're not error checking the TWI, which might be a bad idea
	twiRead( 0x48, (uint8_t *) &temp, 2 );
//	if ((temp & 0x0100) == 0x0100)
//	{
		//Indicates a negative number, time to fill in the upper section with ones
//		temp = temp | 0xfe00;
//	}
	return temp;
}

void vMonitorTemp(void *pvParameters)
{
	DDRD = 0x03;
	PORTD |= 0x03;//enable pull-ups on the I2C bus

	// disable analog comparator
//	ACSR = ( ACSR & (uint8_t) ~( _BV( ACIE ) ) ) | _BV( ACD );
  
	// initialize TWI
	twiInit( 10 );

	// initialize Timer/Counter2
//	OCR2A = TIMER2_OUTPUT_COMPARE - 1;
  
	// select CTC mode (WGM21..WGM20 = 10) and Clock Select
//	TCCR2A = ( 1 << WGM21 ) | ( 0 << WGM20 ) | TIMER2_CS;
//	TIMSK2 |= _BV( OCIE2A );  // enable Timer/Counter2 Output Compare Match interrupt

	// has prescaler (ATmega128 & newer)
//	TWSR = 0;


	return;
}
