% random_w.m
% generates a Walsh matrix, modify it to take values 0/1,
% randomly draw rows, and then randomly permute them 
% (Duarte, 2008)

%  written by Joelle Barral, 2008
%  (c) Board of Trustees, Leland Stanford Junior University

function mat = random_w(a,b)

DISPLAY = 0;

% x = mtxseq(b); this is taking too long
x = hadamard(b);
r = randperm(b);

mat = zeros(a,b);
for jj = 1:b
    col = x(:,r(jj));
    rr = randperm(b);
    mat(:,jj)=col(rr(1:a));
end
mat = (mat+ones(a,b))/2; 

if (DISPLAY)
    figure
    imshow(mat,[])
end

