% random_sp.m
% Generate an a * b matrix where each column has sparsity d
% (Berinde, 2008)

%  written by Joelle Barral, 2008
%  (c) Board of Trustees, Leland Stanford Junior University

function mat = random_sp(a,b,d)

DISPLAY = 0; 

if (nargin<3)
    d = floor(a/10)+1; % sparsity
end

mat = zeros(a,b); 
for jj = 1:b
    r = randperm(a); % We choose randomly M indices (the M first ones in r)
    r = r(1:d);
    mat(r,jj)=1;
end

if (DISPLAY)
    figure
    imshow(mat,[])
end
