% random_b.m
% generates a*b independent draws of a Bernoulli random variable with probability of success p.

%  written by Joelle Barral, 2008
%  (c) Board of Trustees, Leland Stanford Junior University

function mat = random_b(a,b,p)

DISPLAY = 0;
if (nargin<3)
    p = 1/2;
end

x = rand(a*b,1);
y = (x <= p)-(x>=p);
mat = reshape(y,a,b);

if (DISPLAY)
    figure
    imshow(mat,[])
end

