% counterexample.m 
%
%   res = counterexample(S,K)
%       res:  
%       S: sparsity (Number of points is S^2)
%       K: number of measurements
%       for example, run counterexample(16,40); 
%       (cf Shepp Logan experiments, 256*256 throw away 84% of samples)

%       The theory stipulates K>>S*(log(N))^4, 
%       but taking N big makes the idea harder to grasp. 

function res = counterexample(S,K)

    if (K<=2*S)
        error('Increase K!')
    end
    N = S*S;
    f = zeros(1,N);
    for jj = 0:S-1
        f(jj*S+1)=1;
    end
    
    % Do K random measurements of f
    T = ceil(N.*rand(K,1)); 
    res = f(T); 
    
    figure
    I = plot(1:N,f,'gx',T,res,'r+'); 
    set(I,'LineWidth',3,'MarkerSize',12);
    H = legend('Function','Measurements'); 
    set(H,'FontSize',18);
    axis([-0.1,N+0.1,-0.1,1.1])