%  SimuNoOptics.m 
%  Main file of the Compressive Sensing demo, without any optics. 
%  l1magic is needed: www.l1-magic.org and the paths have to be properly
%  replaced below. 
%
%  written by Joelle Barral, 2008
%  (c) Board of Trustees, Leland Stanford Junior University

clear all
close all

path(path, './l1magic/Optimization');
path(path, './l1magic/Measurements');
path(path, './l1magic/Data');

% Phantom 
n = 64; 
% You can do a quick try with n=16, but the compressive sensing 
% does not apply then, so the reconstruction will not work

N = n*n;
X = phantom(n);
x = X(:);

M = ceil(N/4); % Number of measurements

C = random_w(M,N);
% Other possible choices:
% C = random_g(M,N);
% C = random_b(M,N); 
% C = random_sp(M,N,8); 

%figure
%imshow(abs(C),[])

C2 = pinv(C);

% measurement vector
y = C*x; 

x_hat_dummy = pinv(C)*y; % L2
X_dummy = reshape(x_hat_dummy,n,n);
x_hat_cs = tveq_logbarrier(x_hat_dummy, C, C2, y, 1e-1, 2, 1e-8, 600); 
X_cs = reshape(x_hat_cs, n, n);

figure
subplot(1,3,1)
imshow(X,[])
title('Original')
subplot(1,3,2)
imshow(X_dummy,[])
title('L2')
subplot(1,3,3)
imshow(X_cs,[])
title('TV L1')
        