
%function scaleImage

imDir = 'F:\LED_Test1\MCC'


fname1 = fullfile(imDir,'mcc_001.nef');
fname2 = fullfile(imDir,'mcc_002.nef');
fname3 = fullfile(imDir,'mcc_003.nef');
fname4 = fullfile(imDir,'mcc_004.nef');
fname5 = fullfile(imDir,'mcc_005.nef');
fname6 = fullfile(imDir,'mcc_006.nef');
fname7 = fullfile(imDir,'mcc_007.nef');
fname8 = fullfile(imDir,'mcc_000.nef');

tmp   = nefReadImage(fname1);
[nRows,nCols,nColors] = size(tmp);

in = {fname1,fname2,fname3,fname4,fname5,fname6,fname7,fname8};
nImages = length(in);

tmpR = zeros(nRows,nCols,nImages);
tmpG = zeros(nRows,nCols,nImages);
tmpB = zeros(nRows,nCols,nImages);

for kk = 1:nImages
    tmp = nefReadImage(char(in(kk)));
    disp(sprintf('Reading Image number %d',kk))
    tmpR(:,:,kk) = tmp(:,:,1);
    tmpG(:,:,kk) = tmp(:,:,2);
    tmpB(:,:,kk) = tmp(:,:,3);
end

load 'F:\LED_Test1\Spatial Maps\spatial_maps.mat'

%blue:
scaled_data_blue_R = tmpR(:,:,1).*spatial_map_blue_R;
scaled_data_blue_G = tmpG(:,:,1).*spatial_map_blue_G;
scaled_data_blue_B = tmpB(:,:,1).*spatial_map_blue_B;

save mcc_pictures scaled_data_blue_R
save mcc_pictures scaled_data_blue_G -APPEND
save mcc_pictures scaled_data_blue_B -APPEND

clear scaled_data_blue_R scaled_data_blue_G scaled_data_blue_B

%cyan:
scaled_data_cyan_R = tmpR(:,:,2).*spatial_map_cyan_R;
scaled_data_cyan_G = tmpG(:,:,2).*spatial_map_cyan_G;
scaled_data_cyan_B = tmpB(:,:,2).*spatial_map_cyan_B;

save mcc_pictures scaled_data_cyan_R -APPEND
save mcc_pictures scaled_data_cyan_G -APPEND
save mcc_pictures scaled_data_cyan_B -APPEND

clear scaled_data_cyan_R scaled_data_cyan_G scaled_data_cyan_B

%green:
scaled_data_green_R = tmpR(:,:,3).*spatial_map_green_R;
scaled_data_green_G = tmpG(:,:,3).*spatial_map_green_G;
scaled_data_green_B = tmpB(:,:,3).*spatial_map_green_B;

save mcc_pictures scaled_data_green_R -APPEND
save mcc_pictures scaled_data_green_G -APPEND
save mcc_pictures scaled_data_green_B -APPEND

clear scaled_data_green_R scaled_data_green_G scaled_data_green_B

%amber:
scaled_data_amber_R = tmpR(:,:,4).*spatial_map_amber_R;
scaled_data_amber_G = tmpG(:,:,4).*spatial_map_amber_G;
scaled_data_amber_B = tmpB(:,:,4).*spatial_map_amber_B;

save mcc_pictures scaled_data_amber_R -APPEND
save mcc_pictures scaled_data_amber_G -APPEND
save mcc_pictures scaled_data_amber_B -APPEND

clear scaled_data_amber_R scaled_data_amber_G scaled_data_amber_B

%red:
scaled_data_red_R = tmpR(:,:,5).*spatial_map_red_R;
scaled_data_red_G = tmpG(:,:,5).*spatial_map_red_G;
scaled_data_red_B = tmpB(:,:,5).*spatial_map_red_B;

save mcc_pictures scaled_data_red_R -APPEND
save mcc_pictures scaled_data_red_G -APPEND
save mcc_pictures scaled_data_red_B -APPEND

clear scaled_data_red_R scaled_data_red_G scaled_data_red_B

%ir880:
scaled_data_ir880_R = tmpR(:,:,6).*spatial_map_ir880_R;
scaled_data_ir880_G = tmpG(:,:,6).*spatial_map_ir880_G;
scaled_data_ir880_B = tmpB(:,:,6).*spatial_map_ir880_B;

save mcc_pictures scaled_data_ir880_R -APPEND
save mcc_pictures scaled_data_ir880_G -APPEND
save mcc_pictures scaled_data_ir880_B -APPEND

clear scaled_data_ir880_R scaled_data_ir880_G scaled_data_ir880_B

%ir940:
scaled_data_ir940_R = tmpR(:,:,7).*spatial_map_ir940_R;
scaled_data_ir940_G = tmpG(:,:,7).*spatial_map_ir940_G;
scaled_data_ir940_B = tmpB(:,:,7).*spatial_map_ir940_B;

save mcc_pictures scaled_data_ir940_R -APPEND
save mcc_pictures scaled_data_ir940_G -APPEND
save mcc_pictures scaled_data_ir940_B -APPEND

clear scaled_data_ir940_R scaled_data_ir940_G scaled_data_ir940_B

%uv:
scaled_data_uv_R = tmpR(:,:,8).*spatial_map_uv_R;
scaled_data_uv_G = tmpG(:,:,8).*spatial_map_uv_G;
scaled_data_uv_B = tmpB(:,:,8).*spatial_map_uv_B;

save mcc_pictures scaled_data_uv_R -APPEND
save mcc_pictures scaled_data_uv_G -APPEND
save mcc_pictures scaled_data_uv_B -APPEND

clear scaled_data_uv_R scaled_data_uv_G scaled_data_uv_B










