%% 

%function out = averageRawChannels(in)

imDir = 'F:\LED_Test1\grey_target_testing'

fname1 = fullfile(imDir,'grey040.nef');
fname2 = fullfile(imDir,'grey087.nef');
fname3 = fullfile(imDir,'grey088.nef');
fname4 = fullfile(imDir,'grey089.nef');
%fname5 = fullfile(imDir,'grey069.nef');
%fname6 = fullfile(imDir,'grey076.nef');

%tmp   = nefReadImage(fname1);

[nRows,nCols,nColors] = size(tmp);


in = {fname1,fname2,fname3,fname4};

nImages = length(in);

tmpR = zeros(nRows,nCols,nImages);
tmpG = zeros(nRows,nCols,nImages);
tmpB = zeros(nRows,nCols,nImages);

for kk = 1:nImages
    tmp = nefReadImage(char(in(kk)));
    disp(sprintf('Reading Image number %d',kk))
    tmpR(:,:,kk) = tmp(:,:,1);
    tmpG(:,:,kk) = tmp(:,:,2);
    tmpB(:,:,kk) = tmp(:,:,3);
end


averageR = mean(tmpR,3);
averageG = mean(tmpG,3);
averageB = mean(tmpB,3);

save average_uv_R averageR
save average_uv_G averageG
save average_uv_B averageB



