%% ===== Initialize variables and load data =====
clear;  % close all;
% Note: pwd should be C:\Documents and Settings\David\Desktop\Stanford\PSYCH221\Project\led_project

% refData has a number of reflectances as its columns
% load our measured reflectance data (many hundreds of samples)
ref = load('refData');

% load the generated F
load('F');


% indicies under 0.1: 
% elimChannels = [1,4,7,9,12,14,15,19,20,21,22]';
% indicies to elim according to eye:
% elimChannels = [12 15 19 20 21 22]';
elimChannels = []'; % turns out this reduces noise for cvx values

% LOAD OUR IMAGE, and eliminate noisy/low signal channels
% VARIABLES: filterImages, centers, and n_ptsamples
tmp = load('F:\Elza Stephanie David\ledSpectralImaging\filterImagesMCC.mat');
filterImages = tmp.filterImages; clear tmp;
filterImages(:,:,elimChannels)=[]; % removing channels
F(:,elimChannels)=[];
tmp = load('F:\Elza Stephanie David\led_project\centersMCC.mat');
centers = round(tmp.centers); clear tmp;
% centers: col 1 contains x (along cols of image), col 2 is y (along rows of image)
n_ptsamples = size(centers,1); %n_ptsamples is from filterImages and centers
clear tmp;

% sanity test on image and centers
go = 0;
if go > 0
    figure; imagesc(filterImages(:,:,3)); colormap(gray);
    hold on; scatter(centers(:,1), centers(:,2));
    for ii = 1:size(centers,1),
        text(centers(ii,1),centers(ii,2),num2str(ii),'VerticalAlignment','bottom','Color','red')
    end
    hold off;
end


% Load skin reflectances
tempdir = 'F:\Elza Stephanie David\meas_spectra\';
files = {'elsa_skin.mat', 'stephanie_skin.mat', 'joyce_skin.mat'};
x_skin = []; % x_skin = zeros(length(files), 173);
for ii = 1:length(files),
    tmp = load([tempdir files{ii}]);
    x_skin = [x_skin 0.9*tmp.data/max(tmp.data)];
end
clear tmp; load wave;
figure; plot(wave,x_skin); legend('elza','stephanie','joyce','Location', 'Northwest');
title('Directly measured skin reflectance');

% Load MCC refs
tmp = load('F:\Elza Stephanie David\ledSpectralImaging\mccReflectances.mat');
mccRefs = tmp.data; 
wave = tmp.wavelength; clear tmp;
[nBands,nSpectra] = size(mccRefs);
clear tmp;

% extract reused dims and data
n_wl = size(ref.data,1);
n_meas = size(ref.data,2);
n_chan = size(F,2);
xmin = min(ref.wavelength);
xmax = max(ref.wavelength);

%% ===== BEGIN: calculate centers of  an image and store it to 'centers'====
% store centers:
go = 0;
if go > 0,
    n_ptsamples = 24; % for each MCC point
    figure; imagesc(filterImages(:,:,1));
    centers = [];
    imagesc(filterImages(:,:,3));
    for ii = 1:n_ptsamples,
        
        [x y] = ginput(1);
        centers = [centers; x y];
    end
    % save centersFilename centers;
end
% ===== END: calculate centers of  an image and store it to 'centers'====


%% ===== BEGIN: append our measured reflectance data to Manu's ======
go = 0;
if go > 0,
    % Normalize our data to 0.9 then add to refData -DL
    meas_dir = 'C:\Documents and Settings\David\Desktop\Stanford\PSYCH221\Project\meas_spectra';
    measd = dir(meas_dir);

    % store all our data in measSpectra
    nMeas = length(measd);
    measSpectra = [];
    for kk = 3:nMeas
        tmp_meas = load(sprintf('%s\\%s',meas_dir,measd(kk).name));
        measSpectra = [measSpectra tmp_meas.data];
    end

    % normalize each col of measSpectra
    measSpectraOrig = measSpectra; % store original copy
    for ii = 1:size(measSpectra,2),
        measSpectra(:,ii) = measSpectra(:,ii)*0.9/max(measSpectra(:,ii));
    end

%     save measSpectra measSpectra
end
% ===== END: append our measured reflectance data to Manu's ======
load measSpectra; % this already has it, so just load it


%% ===== Generate C, the data from camera, either sim. or real =====
% C = F' * x, where x are the reflectances
Csim_refdata = F'*ref.data;
Csimmcc = F'*mccRefs;
Csimskin = F'*x_skin;
Creal = [];

% Only take our center points from filterImages
for ii = 1:n_ptsamples,
    Creal = [Creal squeeze(filterImages(centers(ii,2),centers(ii,1),:))]; % row, col
end
% disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
% pause(1);
% disp('fudging scaling!!');
% pause(1);
% Creal = Creal/600;

go = 0; % ----- plot stuff -----
if go > 0
    % figure; plot(Creal(:,13:18)); title('real data, reflectances from 3rd row of MCC samples');
    % figure; plot(Csimmcc(:,13:18)); title('simulated data, reflectances from 3rd row of MCC samples');
    figure; plot(Creal(:,13:15)); title('real data, reflectances from BGR of MCC samples');
    figure; plot(Csimmcc(:,13:15)); title('simulated data, reflectances from BGR of MCC samples');
end

% Generate x_hat, a_hat
pinvFt = pinv(F');
x_hat_pinv_Creal = pinvFt*Creal; 
x_hat_pinv_Csimmcc = pinvFt*Csimmcc;
x_hat_pinv_Csim_refdata = pinvFt*Csim_refdata;
x_hat_pinv_Csimskin = pinvFt*Csimskin;

% a_hat_pinv = pinv(P) * x_hat_pinv;


%% ----- cvx version of Manu's regularization critSensitivities -----
go = 1;
if go > 0
    tic
    cvx_quiet(true);
    L=diag(2*ones(n_wl,1),0) + diag(-ones(n_wl-1,1),-1) + diag(-ones(n_wl-1,1),1);

    normmaxerror = 0;
    % regParam = 6.0139e-01; % reference to critSensitivies value
    rPcvx1 = 1e2; % (may not be used in code) bigger means more weight on minimizing error 
    rPcvx2 = 1e-1; % bigger means more weight on smoothness
    
    % ----- Data to be optimized -----
%     % ref.data
%     C_data = Csim_refdata;
%     n_loops = size(C_data, 2);
%     x_pinv = x_hat_pinv_Csim_refdata;
%     x_orig = ref.data;
%     fn_str = 'refdata ';
    
%     % filterImages centers
%     C_data = Creal;
%     n_loops = size(C_data, 2);
%     x_pinv = x_hat_pinv_Creal;
%     x_orig = [];
%     fn_str = 'real ';

%     % simulated mcc
%     C_data = Csimmcc;
%     n_loops = size(C_data, 2);
%     x_pinv = x_hat_pinv_Csimmcc;
%     x_orig = mccRefs;
%     fn_str = 'sim mcc ';

%     % simulated skin reflectances
%     C_data = Csimskin;
%     n_loops = size(C_data, 2);
%     x_pinv = x_hat_pinv_Csimskin;
%     x_orig = x_skin;
%     fn_str = 'sim skin ';
    
    % --------------------------------
    
    % All the x values from cvx stored in one matrix
    XCVX = zeros(n_wl, n_loops);
    
    for ii = 1:n_loops,
        cc = C_data(:,ii);

        % --------------- CVX 1 ------------------
        go = 1;
        if go == 1
            % disp('Using cvx method ONE');
            cvx_begin
            variable xcvx(n_wl,1);
            minimize (norm(L*xcvx)) % + rPcvx1*norm(cc-F'*xcvx))
            subject to
                norm(cc-F'*xcvx) <= normmaxerror;
                xcvx >= 0;
                xcvx <= 1;
            cvx_end

            % --------------- CVX 2 ------------------
        elseif go == 2
            % Alternative method: 
            % disp('Using cvx method TWO');
            cvx_begin
            variable xcvx(n_wl,1);
            minimize (norm(cc-F'*xcvx) + rPcvx2*norm(L*xcvx)) 
            %        |------- phi ---| + |------ phireg ---|
            % Note: not quite the same regParam in critSensitivities since
            % we use norm, not x'*x, which is norm^2
            cvx_end
        end
        
        disp([num2str(ii) ': ' cvx_status]);
        
        % plot figures for this optimization
        go = 1;
        if go > 0
            figure; hold on;
            plot(wave, xcvx);
            plot(wave, x_pinv(:,ii), 'g');
            if ~isempty(x_orig)
                plot(wave, x_orig(:,ii), 'r');
                legend('cvx constrained min.','pseudoinverse','orig','Location','NorthWest');
            else
                legend('cvx constrained min.','pseudoinverse','Location','NorthWest');
            end
            axis([xmin xmax 0 1]);
            title([fn_str(1:end-1) ':  cvx reflectance: ' num2str(ii) ' with normmaxerror: ' num2str(normmaxerror)]);
%             title(['cvx reflectance: ' num2str(ii) ' with regParam: ' num2str(rPcvx2)]);
            hold off;
            saveas(gcf, [fn_str num2str(ii)], 'png');
        end

        XCVX(:,ii) = xcvx;
    end
%     disp(['CVX time for ' num2str(n_loops) ' # loops'] );
    toc
%     save XCVX XCVX;
end


%% ===== BEGIN: calculate the SVD, energy concentration in data =======
go = 0;
if go > 0
    % append to refData, keep original
    ref.dataorig = ref.data;
    ref.data = [ref.dataorig measSpectra];

    % create vars for easy access
    n_wl = size(ref.data,1);
    n_meas = size(ref.data,2);

    % Find SVD of refData
    [U sig V] = svd(ref.data); % U: 173x173 vs econ: 173x173; sig: 173x673 vs econ: 173x173
    % FIX ME i think that's the right one

    % plot sigmas
    sig_list = zeros(min(size(sig,1),size(sig,2)),1);
    for ii = 1:min(size(sig,1),size(sig,2)), sig_list(ii) = sig(ii,ii); end
    sig_list_norm = sig_list/sum(sig_list);
    % figure; plot(sig_list_norm(1:30),'x'); title('Top 30 SVD sigma values');
    % figure; stairs(cumsum(sig_list_norm)); title('Cumulative sum of SVD energies');

    % Crop 15 values or eigenvectors: about 95% of the energy
    keepcols = 15;
    % P = zeros(size(U));
    P = U(:,1:keepcols);
end
% ===== END: calculate the SVD, energy concentration in data =======

