% BEGIN: generate IR data from xls file------------------
% tmp = xlsread('C:\Documents and Settings\David\Desktop\Stanford\PSYCH221\Project\led_project\IR.xls')
% tmp
% xx = 380:4:1068;
% plot(tmp(:,1),tmp(:,2))
% yy1 = interp1(tmp(:,1),tmp(:,2),xx,'pchip',0);
% figure;plot(xx,yy1)
% 
% name = 'ir_xls';
% data = yy1';
% wavelength = xx';
% 
% % ir_xls.peak = -1;
% % ir_xls.type = 'radiance';
% save ir_xls name data wavelength;
% END: generate IR data from xls file------------------


% ------------
% stephanie's order of LED Spectra: blue, cyan, green, amber, red, ir_880,
% ir_940, uv
% ------------


%% Form F, where c = F*x,
% c are the color measurements, x is the reflectance, and F is the system
% matrix, which is a combination of the camera color filters and the
% iluminants. Each row of F is a pointwise product of one camra color 
% channel and an illuminant.  

led_dir = 'F:\Elza Stephanie David\led_spectra';
d = dir(led_dir)

nLeds = length(d);
ledSpectra = [];
for kk = 3:nLeds
    tmp = load(sprintf('%s\\%s',led_dir,d(kk).name));
    disp(d(kk).name);
    ledSpectra = [ledSpectra tmp.data/max(tmp.data)]; % scale by max
end
% Current F has these:
% 1blue.mat
% 2cyan.mat
% 3green.mat
% 4amber.mat
% 5red.mat
% 6ir_880.mat
% 7ir_940.mat
% 8uv.mat

% -------------------
% make fake IR to fill in gaps
go = 0;
if go > 0,
    irlow = circshift(ledSpectra(:,1), [-20]);
    irhigh = circshift(ledSpectra(:,1), [20]);
    irlowlow = circshift(ledSpectra(:,1), [-40]);
    irhighhigh = circshift(ledSpectra(:,1), [40]);
    irhighhigh(1:50) = 0;
    
    figure; plot(irhighhigh);title('irhighhigh');
    figure; plot(irhigh);title('irhigh');
    figure; plot(irlowlow);title('irlowlow');
    figure; plot(irlow);title('irlow');
    
    ledSpectra = [irhigh irhighhigh irlow irlowlow ledSpectra];
    figure; plot(ledSpectra);
end

% -------------------

tmp = load('d200irSensitivities');
cam = tmp.data;

[nSamples,nLeds] = size(ledSpectra);

F = zeros(nSamples,3*nLeds);

for kk = 1:nLeds
    
    F(:, 3*(kk-1) + 1: 3*(kk-1) + 3   ) = ...
        diag(ledSpectra(:,kk))*cam;
end
    
% save F F;