function phi=critSensitivities(f,Y,S,regParam)
% Regularization criterion
% f is initial value of sensitivity function
% Y has RGB data
% S is spectral data

%Y=rY;
%f=f1;

%Y=Y;
mm=length(f);

% Laplacian for penalty on roughness
L=diag(2*ones(mm,1),0) + diag(-ones(mm-1,1),-1) + diag(-ones(mm-1,1),1);

phiReg=regParam*(L*f)'*(L*f);

%phiReg=0;

% data term
phi=(Y-S*f)'*(Y-S*f);

phi=phi+phiReg;
