function cfaImage = nefReadCFAImage(imName,scaling);

% Returns CFA image 
%
% cfaImage=nefReadCFAImage(imName,scaling);
% 
% imName is a string that has the full path to the NEF image
%
% set scaling to 1 (default) to indicate that data must be normalized to
% give intensities for an exposure time of 1 sec. 
% set scaling to 0 if normalization is not desired.
%
% EXAMPLE:
%
%   imName='/home/parmar/samsung/data/multispectral/20070731/gray_03.nef';
%   cfaImage=nefReadCFAImage(imName,1);

% mp - Jul 2007

if ischar(imName) %
    if exist(imName) 
        imFile=imName;
    else
        error('Input must be a valid Nikon NEF file');        
    end

    
    if nargin==1  % Set default to normalize by exposure time
        scaling=1; 
    elseif nargin==2
        if ~( scaling==0 || scaling==1 )
            error('scaling should be either 1 or 0.');
        end
    else
        error('Incorrect number of inputs; see HELP for details')
    end

    %disp(sprintf('Reading image %d - %s', imageNumber, inFile));
    imData = nefDCrawWrapper(imFile);
    
    if scaling
        exposureStr=imData.aperture; % This will be a string that ends with ' sec'
        tmp=findstr(exposureStr,'sec');
        exposure=str2num(exposureStr(1:tmp-2));
        cfaImage=double(imData.rawimage)/exposure;
    else
        cfaImage=double(imData.rawimage);
    end

else
    error('Invalid input. See help for details.');
end
