
% 
ms={'mcc1.mat';...
    'mcc2.mat';...
    'mcc3.mat';...
    'mcc4.mat';...
    'mcc5.mat';...
    'mcc6.mat';...
    'mcc7.mat';...
    'mcc8.mat';...
    'mcc9.mat';...
    'mcc10.mat';...
    'mcc11.mat';...
    'mcc12.mat';...
    'mcc13.mat';...
    'mcc14.mat';...
    'mcc15.mat';...
    'mcc16.mat';...
    'mcc17.mat';...
    'mcc18.mat';...
    'mcc19.mat';...
    'mcc20.mat';...
    'mcc21.mat';...
    'mcc22.mat';...
    'mcc23.mat';...
    'mcc24.mat'};    
     
tmp = load('mccReflectances.mat')

mccRefs = tmp.data;
wave = tmp.wavelength;
[nBands,nSpectra]=size(mccRefs);

% % 
% % ms_calibration_illuminant.mat
% 
% %%


%% Show image from which we extract data 
calib_file='filterImagesMCC';
tmp=load(calib_file);
filterImages = tmp.filterImages;
elimChannels = [12 15 19 20 21 22]';
filterImages(:,:,elimChannels)=[];

tmp=filterImages(:,:,3);
% tmp2=tmp(:,400:end,:);
% tmp=tmp/max(tmp2(:)); tmp(tmp>1)=1;
imagesc(tmp/max(tmp(:))); axis image;

spotSize=10; %% Number of points selected for each smooth region 

colorChannels=[];

% %save vegCalibData allSpectra colorChannels 
for kk=1:nSpectra
    
    disp(sprintf('Please click on a smooth region in patch -- %d',kk))

    
    [xx,yy]=ginput(1);
    spotCols=round(xx)-5:round(xx)+4;
    spotRows=round(yy)-5:round(yy)+4;    
    
    tmp=filterImages(spotRows,spotCols,:);
        
    tmpColorChannels=[];
    for kkR=1:spotSize
        for kkC=1:spotSize
        tmp2=squeeze(tmp(kkR,kkC,:));
        tmpColorChannels=[tmpColorChannels,tmp2(:)];
        end
    end
    
    colorChannels=[colorChannels,tmpColorChannels];       

    disp('Press any key to continue..'); pause
end
% %save fruitCalibData allSpectra colorChannels 


%% setup inverse problem
% 
% clear all;
% load vegCalibData
%load fruitCalibData


spotSize=10;
mccSpectra=kron(mccRefs,ones(1,spotSize^2));


M=mccSpectra*pinv(colorChannels);    


%% Find multispectral image
load inversionMatrix;

load('filterImagesJoyce');
%illuminant=load(fullfile('spectra_calib','illuminant.mat'))
%L=diag(illuminant.data);
elimChannels = [12 15 19 20 21 22]';
filterImages(:,:,elimChannels)=[];


[nBands, nFilters]=size(M);
[nRows,nCols,nFilters]=size(filterImages);
spectralImage=zeros(nRows,nCols,nBands);
for rowNumber=1:nRows
    for colNumber=1:nCols
      yy=squeeze(filterImages(rowNumber,colNumber,:));%,1:15));%./channelScales; 
      %aHat=Q*yy;
      %xxHat=P*aHat;
        xxHat=M*yy;
        kk=find(xxHat<0); xxHat(kk)=0;
       spectralImage(rowNumber,colNumber,:)=xxHat;%./diag(L);   
      
    end
end

% save spectralImageJoyce spectralImage; disp('done saving');

%% calculate avg reflectance over a patch:
go = 0;
if go > 0,
    % Generate the avg patches to get skin reflectance avgs
%     load('F:\Elza Stephanie David\ledSpectralImaging\spectralImageElza.mat');
%     x1 = 227; x2 = 256;
%     y1 = 172; y2 = 196;
%     patch = spectralImage(y1:y2, x1:x2, :);
%     save patchelza patch;
%     clear spectralImage;
% 
%     load('F:\Elza Stephanie David\ledSpectralImaging\spectralImageStephanie.mat');
%     x1 = 261; x2 = 286;
%     y1 = 233; y2 = 254;
%     patch = spectralImage(y1:y2, x1:x2, :);
%     save patchstephanie patch;
%     clear spectralImage;
%     
%     load('F:\Elza Stephanie David\ledSpectralImaging\spectralImageJoyce.mat');
%     x1 = 227; x2 = 273;
%     y1 = 118; y2 = 159;
%     patch = spectralImage(y1:y2, x1:x2, :);
%     save patchjoyce patch;
%     clear spectralImage;

%     load('F:\Elza Stephanie David\ledSpectralImaging\spectralImageMCC.mat');
%     x1 = 48; x2 = 94;
%     y1 = 285; y2 = 323;
%     patch = spectralImage(y1:y2, x1:x2, :);
%     save patchMCCB patch;
%     x1 = 156; x2 = 216;
%     y1 = 271; y2 = 327;
%     patch = spectralImage(y1:y2, x1:x2, :);
%     save patchMCCG patch;
%     x1 = 268; x2 = 332;
%     y1 = 270; y2 = 323;
%     patch = spectralImage(y1:y2, x1:x2, :);
%     save patchMCCR patch;
%     clear spectralImage;

    
    % Generate plots and compare to measured skin reflectances
    load wave;
    xmin = min(wave); xmax = max(wave);
    load patchelza;
    avgpatch = squeeze(sum(sum(patch,1),2))/(size(patch,1)*size(patch,2));
    figure; plot(wave, 0.9*avgpatch/max(avgpatch),'b-'); 
    title('Elza skin reflectance');
    xlabel('wavelength'); ylabel('intensity');
    tmp = load('F:\Elza Stephanie David\meas_spectra\elsa_skin.mat');
    hold on; plot(wave, 0.9*tmp.data/max(tmp.data), 'b.');
    axis([xmin, xmax, 0, 1]);
    legend('reconstructed','measured','location','Northwest');
    hold off;
    saveas(gcf, 'elza_skin_recon', 'png');
    
    load wave;
    xmin = min(wave); xmax = max(wave);
    load patchstephanie;
    avgpatch = squeeze(sum(sum(patch,1),2))/(size(patch,1)*size(patch,2));
    figure; plot(wave, 0.9*avgpatch/max(avgpatch),'b-'); 
    title('Stephanie skin reflectance');
    xlabel('wavelength'); ylabel('intensity');
    tmp = load('F:\Elza Stephanie David\meas_spectra\stephanie_skin.mat');
    hold on; plot(wave, 0.9*tmp.data/max(tmp.data), 'b.');
    axis([xmin, xmax, 0, 1]);
    legend('reconstructed','measured','location','Northwest');
    hold off;
    saveas(gcf, 'stephanie_skin_recon', 'png');
        
    load wave;
    xmin = min(wave); xmax = max(wave);
    load patchjoyce;
    avgpatch = squeeze(sum(sum(patch,1),2))/(size(patch,1)*size(patch,2));
    figure; plot(wave, 0.9*avgpatch/max(avgpatch),'b-'); 
    title('Joyce skin reflectance');
    xlabel('wavelength'); ylabel('intensity');
    tmp = load('F:\Elza Stephanie David\meas_spectra\joyce_skin.mat');
    hold on; plot(wave, 0.9*tmp.data/max(tmp.data), 'b.');
    axis([xmin, xmax, 0, 1]);
    legend('reconstructed','measured','location','Northwest');
    hold off;
    saveas(gcf, 'joyce_skin_recon', 'png');
    
    
    % Plot MCC reflectances, reconstructed and measured
    load wave;
    xmin = min(wave); xmax = max(wave);
    tmp = load('F:\Elza Stephanie David\ledSpectralImaging\mccReflectances.mat');
    mccRefs = tmp.data; clear tmp;
    figure; hold on; title('MCC reflectances from regularize pseudoinverse recon.'); xlabel('wavelength'); ylabel('intensity');
    axis([xmin, xmax, 0, 1]);

    load patchMCCB;
    avgpatch = squeeze(sum(sum(patch,1),2))/(size(patch,1)*size(patch,2));
    plot(wave, avgpatch,'b-'); 
    plot(wave, mccRefs(:,13), 'b.');
    load patchMCCG;
    avgpatch = squeeze(sum(sum(patch,1),2))/(size(patch,1)*size(patch,2));
    plot(wave, avgpatch,'g-'); 
    plot(wave, mccRefs(:,14), 'g.');
    load patchMCCR;
    avgpatch = squeeze(sum(sum(patch,1),2))/(size(patch,1)*size(patch,2));
    plot(wave, avgpatch,'r-'); 
    plot(wave, mccRefs(:,15), 'r.');
    
    legend('B recon','B measured','G recon','G measured',...
        'R recon','R measured','location','Northwest');
    hold off;
%     saveas(gcf, 'MCC_recon', 'png');
end

%% Render in sRGB space (sort of)


disp('Converting spectral image to sRGB for rendering...')

load augXYZ % augmented XYZ color matching functions zero-padded to include
% IR bands. Values are at every 1 nm
augXYZ=augXYZ(1:4:end,:); % Downsample to every 4nm

xyzImage=zeros(nRows,nCols,3);
for rowNumber=1:nRows
    for colNumber=1:nCols
        xyzImage(rowNumber,colNumber,:)=...
            augXYZ'*squeeze(spectralImage(rowNumber,colNumber,:));
    end
end

srgbImage=zeros(nRows,nCols,3);
load D65; load yCMF;

nN=1/(yCMF'*D65);
xyz1=nN*xyzImage;
xyz1=xyz1;
C = makecform('xyz2srgb');
Irgb = applycform(xyz1,C);

% save IrgbElza Irgb;

% Scaling this since intensity is too small. Check if XYZ to sRGB is
% correct
% imshow(0.6*Irgb)

J = imadjust(Irgb,[],[],0.6); % choose gamma (last parameter for display purposes)
imshow(J)

% Cycle through each frequence and see image:
% print -dpng test.png
% wave = 380:4:1068;
% for kk = 1:173,
%     imagesc(spectralImage(:,:,kk)); colormap(gray)
%     title(num2str(wave(kk)))
%     pause(0.5);
% end

%% save reconstructed images
Irgbstrs = {'IrgbElza','IrgbJoyce','IrgbStephanie','IrgbMCC','IrgbEsser'};
for ii = 1:length(Irgbstrs),
    tmp = load(['F:\Elza Stephanie David\ledSpectralImaging\' Irgbstrs{ii} '.mat']);
    imshow(imadjust(tmp.Irgb,[],[],1));
    saveas(gcf, Irgbstrs{ii}, 'png');
end


