function varargout = handler(varargin)
% HANDLER Application M-file for Handler.fig
%    FIG = HANDLER launch HANDLER GUI.
%    HANDLER1('callback_name', ...) invoke the named callback.

global fig


if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
    
    handles.data.image = 0;
    handles.data.input_image = 0;
    handles.data.anchor_coords.all_points = [];
        
    set(handles.runButton,'Enable','off'); 
    set(handles.parameter2,'Enable','off');        
    set(handles.crop_image,'Enable','off'); 
    set(handles.rotate_image,'Enable','off'); 
    set(handles.flip_image,'Enable','off'); 

    % Show .jpg images under the working directory
    
    cd(pwd);
    
    d=dir;
   
    filenames={};in=1;
    for index=1:length(d);
       if d(index).isdir~=1;
           currFilename = d(index).name;
           tempExtension = currFilename(length(currFilename)-3:length(currFilename));
           if (strcmp(tempExtension,'.jpg'))
               filenames{in}=d(index).name;
               in=in+1;
           end
       end
    end
    
    
    set(handles.filenames_list,'string',filenames);
    guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		% disp(lasterr);
	end

end


%| ABOUT CALLBACKS:
%| GUIDE automatically appends subfunction prototypes to this file, and 
%| sets objects' callback properties to call them through the FEVAL 
%| switchyard above. This comment describes that mechanism.
%|
%| Each callback subfunction declaration has the following form:
%| <SUBFUNCTION_NAME>(H, EVENTDATA, HANDLES, VARARGIN)
%|
%| The subfunction name is composed using the object's Tag and the 
%| callback type separated by '_', e.g. 'slider2_Callback',
%| 'figure1_CloseRequestFcn', 'axis1_ButtondownFcn'.
%|
%| H is the callback object's handle (obtained using GCBO).
%|
%| EVENTDATA is empty, but reserved for future use.
%|
%| HANDLES is a structure containing handles of components in GUI using
%| tags as fieldnames, e.g. handles.figure1, handles.slider2. This
%| structure is created at GUI startup using GUIHANDLES and stored in
%| the figure's application data using GUIDATA. A copy of the structure
%| is passed to each callback.  You can store additional information in
%| this structure at GUI startup, and you can change the structure
%| during callbacks.  Call guidata(h, handles) after changing your
%| copy to replace the stored original so that subsequent callbacks see
%| the updates. Type "help guihandles" and "help guidata" for more
%| information.
%|
%| VARARGIN contains any extra arguments you have passed to the
%| callback. Specify the extra arguments by editing the callback
%| property in the inspector. By default, GUIDE sets the property to:
%| <MFILENAME>('<SUBFUNCTION_NAME>', gcbo, [], guidata(gcbo))
%| Add any extra arguments after the last argument, before the final
%| closing parenthesis.

% --------------------------------------------------------------------
function varargout = flip_image_Callback(h, eventdata, handles, varargin)
    
    % retrieve image data
    init_image = handles.data.image;
   
    % flip limage left to right   
    image_flip = zeros( size(init_image));

    % flip color channels 
    image_flip(:,:,1)=fliplr(init_image(:,:,1));
    image_flip(:,:,2)=fliplr(init_image(:,:,2));
    image_flip(:,:,3)=fliplr(init_image(:,:,3));

    % ensure correct type
    image_flip = uint8(image_flip);

    % display
    axes(handles.initial_image);
    cla;
    imshow(image_flip);
    axis([1 size(image_flip,2) 1 size(image_flip,1)]);
   
    % save ratated image into figure data
    handles.data.input_image = image_flip;
    guidata(gcbo,handles);

% --------------------------------------------------------------------
function varargout = import_image_Callback(h, eventdata, handles, varargin)

    % get file name
    index=(get(handles.filenames_list,'value'));
    namestr=get(handles.filenames_list,'string');
    loadname=char(deblank(namestr(index,:)));
   
    if strcmp( loadname( end - 2 : end ), 'jpg' )
        

        % get directory
        directory = pwd;
   
        if ~strcmp(directory(length(directory)),'\')
            directory = [directory '\'];
        end
    
        filename = [directory loadname];
    
        % disp(' ');
        
        % disp( [ '-- image file name : ' filename ] );    
    
        % load image
        init_image=imread(filename,'jpg');
   
        % save base image into figure data structure
        handles.data.image = init_image;
        guidata(gcbo,handles);
    
        % display image
        axes(handles.initial_image); 
        cla;
        imshow( init_image, []);
        hold on;
        axis([1 size(init_image,2) 1 size(init_image,1)]);
   
        % save file base filename to use when defining anchors
        k=strfind(filename,'.');
        handles.data.base_save_name = char(filename(1:k-1));
        guidata(gcbo,handles);
    
    
        % check to see if anchor point file exists
        % define anchor point filename
        k=strfind(loadname,'.');
        loadname = [char(loadname(1:k-1)) '.mat'];
    
        
    
        % if file present then load anchor data and store in figure data structure
        if sum( strcmp( loadname,namestr ) ) > 0
    
            anchor_coords = load([directory loadname]);
            if isfield( anchor_coords, 'coords' )
        
                % disp( [ '-- BASE image coordinate file FOUND, importing BASE anchors ' ] );
        
                % disp(  [ ' ---- coordinate filename : ' directory loadname ] );
        
                plot(anchor_coords.coords(:,1),anchor_coords.coords(:,2),'y.');
        
                % save anchor data into figure data structure
                handles.data.anchor_coords.all_points = anchor_coords.coords;
                guidata(gcbo,handles);
            else
                % save anchor data into figure data structure
                handles.data.anchor_coords.all_points = [];
                guidata(gcbo,handles);    
                % disp([ ' -- BASE image coordinate file INVALID, reseting BASE anchors ' ] );
            end
        else
            % save anchor data into figure data structure
            handles.data.anchor_coords.all_points = [];
            guidata(gcbo,handles);    
            % disp([ ' -- BASE image coordinate file NOT FOUND, reseting BASE anchors ' ] );
        end
    
        % disp(' ');
    else
        % disp('-- not a valid image file.');
    end
    
    
    set(handles.runButton,'Enable','on'); 
    set(handles.crop_image,'Enable','on'); 
    set(handles.rotate_image,'Enable','on'); 
    set(handles.flip_image,'Enable','on'); 



% --------------------------------------------------------------------
function varargout = crop_image_Callback(h, eventdata, handles, varargin)
   
    % crop image
    axes(handles.initial_image);
    image_cr = imcrop;
    
    % display cropped image
    cla;
    imshow(image_cr);
    axis([1 size(image_cr,2) 1 size(image_cr,1)]);
    
    % save cropped image into figure data
    handles.data.image = image_cr;
    guidata(gcbo,handles);



% --------------------------------------------------------------------
function varargout = rotate_image_Callback(h, eventdata, handles, varargin)

    % retrieve image data
    init_image = handles.data.image;
   
    % define rotated image matrix   
    image_rot = zeros( size(init_image,2), size(init_image,1), 3 );

    % transfer color channels 
    image_rot(:,:,1)=fliplr(init_image(:,:,1)');
    image_rot(:,:,2)=fliplr(init_image(:,:,2)');
    image_rot(:,:,3)=fliplr(init_image(:,:,3)');

    % ensure correct type
    image_rot = uint8(image_rot);

    % display
    axes(handles.initial_image);
    cla;
    imshow(image_rot);
    axis([1 size(image_rot,2) 1 size(image_rot,1)]);
   
    % save ratated image into figure data
    handles.data.image = image_rot;
    guidata(gcbo,handles);


% --------------------------------------------------------------------
function varargout = runButton_Callback(h, eventdata, handles, varargin)

% disp('Button RUNBUTTON is pushed');

func = get(handles.options_menu,'Value');



switch (func)
     case 1         
         k1 = str2num(get(handles.parameter1,'String'));
         imageArray = distort(handles.data.image(:,:,1), k1, func);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         
     case 2
         k1 = str2num(get(handles.parameter1,'String'));
         imageArray = distort(handles.data.image(:,:,1), k1, func);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         
     case 3
         k1 = str2num(get(handles.parameter1,'String'));
         imageArray = distort(handles.data.image(:,:,1), k1, func);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         
     case 4
         k1 = str2num(get(handles.parameter1,'String'));
         imageArray = distort(handles.data.image(:,:,1), k1, func);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         handles.data.image(:,:,1);
         
     case 5
         k1 = str2num(get(handles.parameter1,'String'));
         k2 = str2num(get(handles.parameter2,'String'));                  
         imageArray = distort2(handles.data.image(:,:,1), k1, k2, 1);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);         
         
     case 6
         k1 = str2num(get(handles.parameter1,'String'));
         k2 = str2num(get(handles.parameter2,'String'));                  
         imageArray = distort2(handles.data.image(:,:,1), k1, k2, 2);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         
     case 7
         k1 = str2num(get(handles.parameter1,'String'));
         k2 = str2num(get(handles.parameter2,'String'));          
         imageArray = distort2(handles.data.image(:,:,1), k1, k2, 3);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         
     case 8
         k1 = str2num(get(handles.parameter1,'String'));
         k2 = str2num(get(handles.parameter2,'String'));          
         imageArray = distort2(handles.data.image(:,:,1), k1, k2, 4);         
         axes(handles.processed_image);
         cla;
         imshow(imageArray ,[]);
         
end


% --------------------------------------------------------------------
function varargout = options_menu_Callback(h, eventdata, handles, varargin)

val = get(h,'Value');

switch (val)
     case 1
         set(handles.parameter2,'String','');         
         set(handles.parameter2,'Enable','off');        
     case 2
         set(handles.parameter2,'String','');         
         set(handles.parameter2,'Enable','off');        
     case 3
         set(handles.parameter2,'String','');         
         set(handles.parameter2,'Enable','off');        
     case 4
         set(handles.parameter2,'String','');         
         set(handles.parameter2,'Enable','off');        
     case 5
         set(handles.parameter2,'Enable','on');        
     case 6
         set(handles.parameter2,'Enable','on');        
     case 7
         set(handles.parameter2,'Enable','on');  
end

guidata(gcbo,handles);  % Save the updated Handles Structure    


% --------------------------------------------------------------------
function varargout = parameter1_Callback(h, eventdata, handles, varargin)

value = get(handles.parameter1,'String');

if (isempty(str2num(value)))
    set(handles.parameter1,'String','???')
else
    value = str2num(value);
    % sprintf('Parameter 1 = %d',value)
end    

% --------------------------------------------------------------------
function varargout = parameter2_Callback(h, eventdata, handles, varargin)

value = get(handles.parameter1,'String');

if (isempty(str2num(value)))
    set(handles.parameter1,'String','???')
else
    value = str2num(value);
    % sprintf('Parameter 2 = %d',value)
end   


