%--------------------------------------------------------------------------
%----------------- EE 363 / PSYCH 221 Winter 2007--------------------------
%--------------------------------------------------------------------------
% NAME:   Athanasios Bismpigiannis
% DEPARTMENT: Electrical Engineering
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%B = distort2(image_array, k1, k2, distortion_function)
%input:
%       image_array -> the array of the image to be distorted
%       k1, k2 -> the values of the distortion parameters
%       distortion_function -> selection between numbers 1,..,4
%                              which is the selection of the distortion 
%                              model to be used
%       
%output:
%       B -> the destorted image


function B = distort2(image_array, k1, k2, distortion_function, dis_undis)


%the size of the image to be distorted
[M N]=size(image_array);

B = ones(size(image_array)); 
    
B = double(mean(mean(image_array)))*B;

%the center of the image, which we assume that it is the center of
%distortion as well 
center=[round(N/2) round(M/2)];

image_array(center(2),center(1));

%imview(image_array);

switch distortion_function
    
    %using the distortion function f = 1 + k1*r + k2*(r^2)
    case(1),

        for j = 1 : M
            for i = 1 : N
                %computing the (x,y) coordinates of the image according to the
                %center of the distortion which we assume that it is the center of
                %the image. In the case of our code these are given by the vector
                %center
                x = i - center(1);
                y = j - center(2);
                %computing the distance from the center
                r_d = sqrt( x^2 + y^2 );
                r = r_d * (1 + k1*r_d + k2*(r_d^2));
                
                %finding the (x_d, y_d) coordinates on the distorted image
                if (1 + k1*r + k2*(r^2))== inf
                   x_d = N;
                   y_d = M;
                else
                    x_d = round((x * ( 1 + k1*r + k2*(r^2) )));
                    y_d = round((y * ( 1 + k1*r + k2*(r^2) )));
                end
        
        
                %transforming the coordinates in order to find the position on the
                %array of the distorted image
                x_d = x_d + center(1);
                y_d = y_d + center(2);
                if( x_d > 0 & x_d <= N & y_d > 0 & y_d <= M  )
                    B(y_d,x_d) = image_array(j,i);    
                end
            end
        end
    
    %using the distortion function f = 1 + k1*(r^2) + k2*(r^4)
    case(2),
        
        for j = 1 : M
            for i = 1 : N
                %computing the (x,y) coordinates of the image according to the
                %center of the distortion which we assume that it is the center of
                %the image. In the case of our code these are given by the vector
                %center
                x = i - center(1);
                y = j - center(2);
                %computing the distance from the center
                r_d = sqrt( x^2 + y^2 );
                r = r_d * (1 + k1*(r_d^2) + k2*(r_d^4));
              
                %finding the (x_d, y_d) coordinates on the distorted image
                if (1 + k1*(r^2) + k2*(r^4))== inf
                   x_d = N;
                   y_d = M;
                else
                    x_d = round((x * ( 1 + k1*(r^2) + k2*(r^4) )));
                    y_d = round((y * ( 1 + k1*(r^2) + k2*(r^4) )));
                end
        
                %transforming the coordinates in order to find the position on the
                %array of the distorted image
                x_d = x_d + center(1);
                y_d = y_d + center(2);
                if( x_d > 0 & x_d <= N & y_d > 0 & y_d <= M  )
                    B(y_d,x_d) = image_array(j,i);    
                end
            end
        end
    
    %using the distortion function f = 1/(1 + k1*r + k2*(r^2))
    case(3),

        for j = 1 : M
            for i = 1 : N
                %computing the (x,y) coordinates of the image according to the
                %center of the distortion which we assume that it is the center of
                %the image. In the case of our code these are given by the vector
                %center
                x = i - center(1);
                y = j - center(2);
                %computing the distance from the center
                r_d = sqrt( x^2 + y^2 );
                r = r_d * (1/(1 + k1*r_d + k2*(r_d^2)));
                
                %finding the (x_d, y_d) coordinates on the distorted image
                if (1/(1 + k1*r + k2*(r^2)))==0
                   x_d = N;
                   y_d = M;
                else
                    x_d = round((x * ( 1/(1 + k1*r + k2*(r^2)) )));
                    y_d = round((y * ( 1/(1 + k1*r + k2*(r^2)) )));
                end
        
        
                %transforming the coordinates in order to find the position on the
                %array of the distorted image
                x_d = x_d + center(1);
                y_d = y_d + center(2);
                if( x_d > 0 & x_d <= N & y_d > 0 & y_d <= M  )
                    B(y_d,x_d) = image_array(j,i);    
                end
            end
             
        end
    
        
        
        %using the distortion function f = (1+k1*r)/(1 + k2*(r^2))
    case(4),

        for j = 1 : M
            for i = 1 : N
                %computing the (x,y) coordinates of the image according to the
                %center of the distortion which we assume that it is the center of
                %the image. In the case of our code these are given by the vector
                %center
                x = i - center(1);
                y = j - center(2);
                %computing the distance from the center
                r_d = sqrt( x^2 + y^2 );
                r = r_d * ((1+k1*r_d)/(1 + k2*(r_d^2)));
                
                %finding the (x_d, y_d) coordinates on the distorted image
                if ((1+k1*r)/(1 + k2*(r^2)))==0
                   x_d = N;
                   y_d = M;
                else
                    x_d = round((x * ( (1+k1*r)/(1 + k2*(r^2)) )));
                    y_d = round((y * ( (1+k1*r)/(1 + k2*(r^2)) )));
                end
        
        
                %transforming the coordinates in order to find the position on the
                %array of the distorted image
                x_d = x_d + center(1);
                y_d = y_d + center(2);
                if( x_d > 0 & x_d <= N & y_d > 0 & y_d <= M  )
                    B(y_d,x_d) = image_array(j,i);    
                end
            end
             
        end
end    