%% get maximum LED value and maximum LCD value
function [LED_luminance_max LCD_luminance_max] = brsGetMaximumLuminance(max_backlight,max_LCD,stabilize,exposure,exp_mul,gamma)
    % Calculate exposure normalizations
    blmax = max_backlight;
    fgmax = max_LCD;
    if exist('exposure','var') && ( exposure~=0 )
        if (stabilize == 1)
            blmax = exposure^(-gamma);
        else
            blmax = blmax/(exposure*fgmax)^gamma;
        end
        fgmax = 1/exposure;
    else
        if exist('exp_mul','var') && ( exp_mul~=0 )
            fgmax = fgmax/exp_mul;
        end
        disp(sprintf('Exposure set to -e %0.5g',1/fgmax));
    end
    LED_luminance_max = blmax;
    LCD_luminance_max = fgmax;
end