function ideal_backlight = brsGetLuminance(image, gamma)
    % Get the luminance of each pixels with proper gamma.
    ideal_backlight = im2bright(image) .^ gamma;

end
%% Color->luminance image converter, based on Radiance source code.
function brightimage = im2bright(color_image)
    % weighted sum of r,G, and B to create a luminance image. 
    % Following definitions are from the Radiance ray-tracer source code,
    % /src/common/color.h
    
    CIE_x_r = 0.640;
    CIE_y_r	= 0.330;
    CIE_x_g	= 0.290;
    CIE_y_g	= 0.600;
    CIE_x_b	= 0.150;
    CIE_y_b	= 0.060;
    CIE_x_w	= 0.3333;
    CIE_y_w	= 0.3333;

    STDPRIMS =	[CIE_x_r,CIE_y_r;...
                 CIE_x_g,CIE_y_g;...
 				CIE_x_b,CIE_y_b];

    CIE_D	  =	(CIE_x_r*(CIE_y_g - CIE_y_b) + ... 
				CIE_x_g*(CIE_y_b - CIE_y_r) +  ...
				CIE_x_b*(CIE_y_r - CIE_y_g)	);
    CIE_C_rD  = ( (1./CIE_y_w) * ...
				( CIE_x_w*(CIE_y_g - CIE_y_b) - ...
				  CIE_y_w*(CIE_x_g - CIE_x_b) + ...
				  CIE_x_g*CIE_y_b - CIE_x_b*CIE_y_g	) );
              
    CIE_C_gD  = ( (1./CIE_y_w) * ...
				( CIE_x_w*(CIE_y_b - CIE_y_r) - ...
				  CIE_y_w*(CIE_x_b - CIE_x_r) - ...
				  CIE_x_r*CIE_y_b + CIE_x_b*CIE_y_r	) );
              
    CIE_C_bD  = ( (1./CIE_y_w) * ...
        ( CIE_x_w*(CIE_y_r - CIE_y_g) - ...
        CIE_y_w*(CIE_x_r - CIE_x_g) + ...
        CIE_x_r*CIE_y_g - CIE_x_g*CIE_y_r	) );

    CIE_rf    = (CIE_y_r*CIE_C_rD/CIE_D);
    CIE_gf    = (CIE_y_g*CIE_C_gD/CIE_D);
    CIE_bf    = (CIE_y_b*CIE_C_bD/CIE_D);

    % As of 9-94, CIE_rf=.265074126, CIE_gf=.670114631 and CIE_bf=.064811243

    % The following definitions are valid for RGB colors only...

    brightimage	= max(CIE_rf*color_image(:,:,1)+CIE_gf*color_image(:,:,2)+CIE_bf*color_image(:,:,3),0);

end
