% This function returns a matrix that indicates whether a rectangular grid
% position actually contains an LED, which are laid out on a hex grid.
function val = brsGetLedPos(image)
    
    frac = inline('x-floor(x)','x');
    x = repmat(0:(size(image,2)-1), size(image,1), 1);
    y = repmat((0:(size(image,1)-1))', 1, size(image,2));
    
    indent_row = ( (frac(y/2 + 0.25) - 0.5) > 0);
%    val = -(frac((x+1-indent_row)/2 + 0.25) - 0.5); % neg.sign seems backwards, but output matches script this way.
     val = (frac((x+1-indent_row)/2 + 0.25) - 0.5); % neg.sign seems backwards, but output matches script this way.
end