function led_image = brsGetLEDImage(normalized_hexagonal_backlight,ledinv,ledmax )
%
    normalized_hexagonal_backlight_T = normalized_hexagonal_backlight';
    LED_pos_val = brsGetLedPos(normalized_hexagonal_backlight_T);
    led_out_t = normalized_hexagonal_backlight_T(LED_pos_val > 0 );   % Only grab values that are actual LEDs in the hex pattern
    led_out_t = floor(ledmax/255*interp1(ledinv(:,1),ledinv(:,2),led_out_t)+0.5);  % Use inverse LED response to map to framebuffer values
    led_image = zeros(31,45);
    for y = 0:30
        led_image(y+1,1:45) = led_out_t((44*floor(y/2)+45*floor((y+1)/2))+1:(44*floor(y/2)+45*floor((y+1)/2))+45);
    end
end