function lcd_image = brsGetLCDImage(resized,backlight2,dstsiz,LCD_luminance_max,lcdinvR, lcdinvG, lcdinvB )
    % Compute correction factors
    m = zeros(dstsiz);
    m(backlight2 > 1e-10) = 1/LCD_luminance_max./backlight2(backlight2 > 1e-10);
    m(backlight2 <= 1e-10) = 1;
    % LED tint constants
    red_tint_correction = 1;
    red_tint_correction = 1; % experimental value, need to be changed according to the measurement.
    green_tint_correction = 1.15;
    % Original DISP14 software uses Green tint correction
    % factor of 1.15.
    blue_tint_correction = 1;
    % LED maximum cutoffs
    red_cutoff = 1;
    green_cutoff = 1;
    blue_cutoff = 1e6 + 1;  % Huge for crosstalk, 1 for CVX
    % Original DISP14 software by Greg Ward uses higher cutoff for Blue.
    
    % Apply tint, LCD response curve
    %   (Why does the blue channel not have a min() with it? I don't know, but
    %    that's how disp14enc has it)
    result_image =        interp1(lcdinvR(:,1), lcdinvR(:,2),  min(m.*resized(:,:,1),red_cutoff)/red_tint_correction    ,[],'extrap');
    result_image(:,:,2) = interp1(lcdinvG(:,1), lcdinvG(:,2),  min(m.*resized(:,:,2),green_cutoff)/green_tint_correction,[],'extrap');
    result_image(:,:,3) = interp1(lcdinvB(:,1), lcdinvB(:,2),  min(m.*resized(:,:,3),blue_cutoff)/blue_tint_correction  ,[],'extrap');
    
    % Normalize on 0-255
    result_image = (min(max(result_image,0),1)).*255; 
    % Composite LED values onto the LCD image
    % result_image(2,3:2+size(led_out,1),:) = reshape(led_out,1,size(led_out,1),size(led_out,2));
    % Convert to uint8
    lcd_image = uint8(result_image);
end