%% Returns backlight image of resolution [1080,1920] Using PSF of a single
%% LED from [31 89] hexagonal LED values
function backlight2 = brsGetBacklightImage2(normalized_hexagonal_backlight,dstsiz, ledrad1,ledrad2,ledcoef1,ledcoef2)
% To view the original version fit for prototype refer to
% brsGetBacklightImage
     gaussrad = [4 6 8 12 16 32 64 128];
     gausswidth = min(89*3,10*gaussrad); % Filter constants
     led_coefficients = [0;103.195;6.464;44.012;78.929;71.404;0;64.792;];  
     %led_coefficients = [22.76;21.45;138.87;80.62;202.21;369.14;83.90;141.28;];
     % relative weights of the test gaussians derived using brsPSF fscript
     % and measured PSF data
     backlight_siz = [31*5 89*3];   % Intermediate size for backlight distribution creation
     dstsiz = [1080 1920]; % full resolution
     backlight2 = zeros(31*5,89*3);
     for m = 1:31
         for n = 1:89
             backlight2(m*5,n*3) = normalized_hexagonal_backlight(m,n);
         end
     end
     % Resize point light image to filtering size
     % you need to know about the hexagonal grid to do this mapping.
     % Filter with the test gaussians used to define LED PSF
     backlight2_sum = zeros(31*5,89*3);
     for idx = 1:length(gaussrad)
         backlight2_gauss(:,:,idx) = led_coefficients(idx)*imfilter(backlight2,fspecial('gaussian',gausswidth(idx),gaussrad(idx)),'replicate');
         backlight2_sum = backlight2_sum + backlight2_gauss(:,:,idx);
     end
     % Resize backlight to full resolution
     backlight2 = 0.0896*imresize(backlight2_sum,dstsiz,'bicubic');
     % 0.0896 is the empirical scaling factor to match the units of Greg
     % Ward's program. Exact Units and scaling factor need to be analized.
end