%% Returns backlight image of resolution [1080,1920] Using PSF of a single
%% LED from [31 89] hexagonal LED values
function backlight2 = brsGetBacklightImage(normalized_hexagonal_backlight)
% Copied from Greg Ward's Disp14, used for prototype BrightSide display
% To view the new version fit for DR37-P refer to brsGetBacklightImage2
    ledcoef1 = 0.75;       % two gaussians.  Radiai are in pixels.
    ledrad1  = 42;         % These define the PSF of the LEDs, as a sum of 
    ledrad2  = 140;
    ledcoef2 = 1-ledcoef1;
    dstsiz = [1080 1920];
    % Filter constants
    backlight_siz = [98 112]; % Intermediate size for backlight distribution creation
    scalef = dstsiz(2)/backlight_siz(2); % LED PSF defined at full resolution, calculate scaling factor for filtering at lower res
    fudge_factor = 0.75; % Empirical value to match disp14enc and Matlab output
    gaussrad1 = ledrad1/scalef*fudge_factor; % Width of 1st gaussian filter, adjusted for scale and filter differences
    gaussrad2 = ledrad2/scalef*fudge_factor; % Width of 2nd gaussian filter, adjusted for scale and filter differences
    gausswidth1 = round(ledrad1/scalef*3)*2+3; % Width of filtering window, just needs to be big enough not to cut off gaussian
    gausswidth2 = round(ledrad2/scalef*3)*2+3; % Width of filtering window, just needs to be big enough not to cut off gaussian

    % Resize point light image to filtering size
    backlight2a = imresize(normalized_hexagonal_backlight,backlight_siz,'bicubic');
    % Filter with the two gaussians used to define LED PSF
    backlight2a_gauss1 = imfilter(backlight2a,fspecial('gaussian',gausswidth1,gaussrad1),'replicate');
    backlight2a_gauss2 = imfilter(backlight2a,fspecial('gaussian',gausswidth2,gaussrad2),'replicate');
    % Combine gaussians
    backlight2a = backlight2a_gauss1 * ledcoef1 + backlight2a_gauss2 * ledcoef2;
    % Resize backlight to full resolution
    backlight2 = 2*imresize(backlight2a,dstsiz,'bicubic');

end