%
% This script illustrates how to put an LED or LCD image onto the
% Brightside display.
%
% Make sure that the Brightside display is turned on and that you set the
% Brightside as the primary monitor.
% 
% Make sure you forced LED 8-bit mode using the HDRCtlv48 software.  It
% will come up and ask you whether the ID assigned to the display is OK.
% Just click OK.  THen in the upper right set the Force 8-Bit flag.
% Continue running the HDRCtlv48 program.
% 
% We need get the people at Brightside to figure out how we can set this.
% They think none of this should be necessary.

% Make sure the brsPaths has been run
% brsPaths

% Create the Brightside object and open a display window

load Images/doll;
load Images/memorial_image;
load Images/MtTamWest_1080;
load Images/Patio_1080;
load Images/StillLife_1080;
load Images/Tree_1080;
load Images/desk_1080;

brs = brsCreate;
brs = openScreen(brs);
ShowCursor;

[lcd_image led_image]=brsEnc(result_image);

brsPutLedImage(brs,0*ones(31,45))
brsPutLedImage(brs,255*ones(31,45))
brsPutLcdImage(brs,ones(1080,1920,3)*255);
brsPutLedImage(brs,led_image)
brsPutLcdImage(brs,lcd_image)


try brs = closeScreen(brs);
catch Screen('closeall'); ShowCursor;
end

% For Joyce : Stored images for quick demo
load Images/demo_images; % loads pre-cencoded images for demo.

brs = brsCreate;
brs = openScreen(brs);
ShowCursor; % Get the handle for the display

brsPutLedImage(brs,desk_led)
brsPutLcdImage(brs,desk_lcd) % display image Desk_1080

brsPutLedImage(brs,doll_led)
brsPutLcdImage(brs,doll_lcd) % display image doll

brsPutLedImage(brs,memorial_led)
brsPutLcdImage(brs,memorial_lcd)

brsPutLedImage(brs,patio_led)
brsPutLcdImage(brs,patio_lcd)

brsPutLedImage(brs,StillLife_led)
brsPutLcdImage(brs,StillLife_lcd)

brsPutLedImage(brs,Tree_led)
brsPutLcdImage(brs,Tree_lcd)

try brs = closeScreen(brs);
catch Screen('closeall'); ShowCursor;
end


