%%  RAW2MAP.m Generates raw data matrix from high dynamic Range .tiff format 
% in order to do this you need to the following.
% step 1. You must have your original *.hdr image. 
% step 2. Using HDRShop (or equivalent) to store the image as *.tif
% step 3. You need to know the spatial resolution of your original image.
% (you can do this in many ways, one is to store the image as *.bmp and you
% can verify the resolution.)
m=512;
n=640;
% Spatial Resolution of the original
file_name='Images/church2_p.tif';
% high Dynamic Range image in .tif format
fid = fopen(file_name,'r');
image = fread(fid,'float32');
fclose(fid);

image = reshape(image(3:2+m*n*3),3,m*n);
image = image';
image = reshape(image,n,m,3);
result_image = zeros(m,n,3);
for index=1:3
    result_image(:,:,index)=image(:,:,index)';
end
save Images\church2_p result_image
% save the raw data as *.map MATLAB matrix.