% this routine will generate the high resol and low resol images

OSD = 0;            % no diag display
background = 0;     % 0 - white background, 1 - black backgorund
zeroTap = 1;        % the number of zero columns to pad to the filtered image

%% initialization (refer to ctAddFont.m)
deVSfont = zeros(1,1,5);
fontFamily = 'Arial';
idealDPI   = 200;
distInt  = 10:2:50;             % observe 18 inches away
kernel = [0 1 3 1 0];
fontInt = [12];
letterInt = ['S' 'W' 'V' 'E' 'F' 'L']-'A'+1;
DPI = [96];

DISTcollector = [];
DISTcolr = zeros(1,1,1);
visualAngle = [];
for fontSize   = fontInt
    jj = fontSize - fontInt(1)+1;
    for ii = letterInt

%%
            letter = char('A'-1+ii)
        refBM           = ctCaptureClearType(letter,idealDPI,fontSize,fontFamily,[]);

        %% make sure srcBM has a width of 3 multiple
        if (mod(size(refBM.dataIndex, 2)+1, 3) == 0)
            tmp = sum(refBM.dataIndex, 1);
            if tmp(1) == 0
                refBM.dataIndex(:, ceil(size(refBM.dataIndex,2)/3)*3) = 0;
            else
                refBM.dataIndex = [zeros(size(refBM.dataIndex, 1),1) refBM.dataIndex];
            end
        elseif (mod(size(refBM.dataIndex, 2)+2, 3) == 0)
            refBM.dataIndex = [zeros(size(refBM.dataIndex, 1),1) refBM.dataIndex zeros(size(refBM.dataIndex, 1),1)];
        end

        % change background to black
        [stmp, refImage] = ctFontFilter(refBM, kernel,'rgb');
        if background == 1
            m = size(refImage,1); n = size(refImage,2);
            stmp = refImage(:,:,1)+refImage(:,:,2)+refImage(:,:,3);
            refImage = reshape(refImage, m*n, 3);
            refImage(find(stmp==3),:) = 0;
            refImage = reshape(refImage, m, n, 3);
        end

        %% render it on display (refer to ctrdRefreshGUIWindow.m)
        vd = vDisplayCreate;
        vd = vDisplaySet(vd, 'inputImage', refImage);
        refRenImage = vdisplayCompute(vd,'inputImage',0,7);

%% repeat for each DPI
        for dpi = DPI
            %% retrieve MS Cleartype Font bitmap (refer to ctAddFont.m, line 91)
            [srcBM, fStyle] = ctCaptureClearType(letter,dpi,fontSize,fontFamily,[]);
            strStyle        = ieInterpretFontStyle(fStyle);

            %% make sure srcBM has a width of 3 multiple
            if (mod(size(srcBM.dataIndex, 2)+1, 3) == 0)
                tmp = sum(srcBM.dataIndex, 1);
                if tmp(1) == 0
                    srcBM.dataIndex(:, ceil(size(srcBM.dataIndex,2)/3)*3) = 0;
                else
                    srcBM.dataIndex = [zeros(size(srcBM.dataIndex, 1),1) srcBM.dataIndex];
                end
            elseif (mod(size(srcBM.dataIndex, 2)+2, 3) == 0)
                srcBM.dataIndex = [zeros(size(srcBM.dataIndex, 1),1) srcBM.dataIndex zeros(size(srcBM.dataIndex, 1),1)];
            end

            %% Filtering with kernel(refer to stimGet.m, line 47)
            [stmp, srcImage] = ctFontFilter(srcBM, kernel,'rgb');
            %% padding zeros columns
            if zeroTap > 0
                [m n p] = size(srcImage);
                tmp = ones(m, n+ 2*zeroTap, p);
                tmp(:, 1+zeroTap:n+zeroTap, :) = srcImage;
                srcImage = tmp;
            end

            % routine that changes the background to black
            % so that we can see only the color artifacts
            if background == 1
                m = size(srcImage,1); n = size(srcImage,2);
                stmp = srcImage(:,:,1)+srcImage(:,:,2)+srcImage(:,:,3);
                srcImage = reshape(srcImage, m*n, 3);
                srcImage(find(stmp==3),:) = 0;          % replace white pixel with black
                srcImage = reshape(srcImage, m, n, 3);
            end

            %% render it on display (refer to ctrdRefreshGUIWindow.m)
            vd = vDisplaySet(vd, 'inputImage', srcImage);
            srcRenImage = vdisplayCompute(vd,'inputImage',0,7);

            if OSD == 1
                figure(7);
                subplot(2,3,1)
                imshow(refBM.dataIndex); axis on; title(['MS BitMap DPI = ' num2str(idealDPI)])
                subplot(2,3,4)
                imshow(srcBM.dataIndex); axis on; title(['Fontsize = ' num2str(fontSize) ' DPI = ' num2str(dpi)])

                subplot(2,3,2)
                imagesc(refImage); axis image; xlabel('samples'); title(['Filtered by ' mat2str(kernel)])
                subplot(2,3,5)
                imagesc(srcImage); axis image; xlabel('samples'); title([mat2str(size(refImage)) '->' mat2str(size(srcImage))])

                subplot(2,3,3);
                imshow(refRenImage); axis on; axis image; xlabel('samples'); title('Rendered (SamplePerPixel = 7)')
                subplot(2,3,6);
                imshow(srcRenImage); axis on; axis image; xlabel('samples'); title([mat2str(size(refRenImage)) '->' mat2str(size(srcRenImage))])
            end

            %%
            %%
            basis.wave  = vDisplayGet(vd, 'WaveLengthSamples');
            basis.basis = vDisplayGet(vd, 'SpectrumOfPrimaries')';
            
            for distance = distInt
                [de deoff rms rmsoff dab2] = test4(refRenImage, srcRenImage, basis, OSD, dpi, distance);
                DISTcollector = [DISTcollector; distance de dab2];
                DISTcolr(ii, distance) = de;
            end
            deVSfont(ii,jj,:) = [de deoff rms rmsoff dab2];
        end

    end

end

%% present DeltaE vs. DPI
figure(100)
H_P = plot(DISTcollector(:,1), DISTcollector(:,2), 'bx-');
set(H_P, 'Color', [1 204/255 0])
hold on;
H_P = plot(DISTcollector(:,1), DISTcollector(:,3), 'bo-');
legend(['Mean \DeltaE'], 'Mean {\Deltaa}^2+{\Deltab}^2', 'Visual Angle')
set(H_P, 'Color', [0 1 0])


xlabel( 'DPI');
ylabel( 'Mean \DeltaE');
H_T = title( ['Letter S-Arial-12 on various DPI (18 inches away)' char(10) '(Reference to a 200 DPI display)']);

H = gcf;
set(H, 'Color', [0 0 0])
set(H, 'Position', [0 50 800 550])
H = gca;
set(H, 'Color', [165/255 53/255 0])
set(H, 'XColor', [1 1 1])
set(H, 'YColor', [1 1 1])
set(H, 'FontAngle', 'italic'); set(H, 'FontSize', 14);

H_X = xlabel(H, 'DPI');
H_Y = ylabel(H, 'Mean \DeltaE');
set(H_X, 'Color', [1 1 1]); set(H_X, 'FontAngle', 'italic'); set(H_X, 'FontSize', 18); set(H_X, 'FontWeight', 'Demi');
set(H_Y, 'Color', [1 1 1]); set(H_Y, 'FontAngle', 'italic'); set(H_Y, 'FontSize', 18); set(H_Y, 'FontWeight', 'Demi');
set(H_T, 'Color', [1 1 1]); set(H_T, 'FontAngle', 'italic'); set(H_T, 'FontSize', 18); set(H_T, 'FontWeight', 'Demi');

hold off;

%% present DeltaE vs. DPI
figure(101)
H_P = plot(DISTcollector(:,1), visualAngle, 'bx-');
set(H_P, 'Color', [1 204/255 0])

H_T = title( ['Visual Angle vs. DPI' char(10) ' (Observed at 18 inches away)' ]);
legend('Letter S-Arial-12')

H = gcf;
set(H, 'Color', [0 0 0])
set(H, 'Position', [0 50 800 550])
H = gca;
set(H, 'Color', [165/255 53/255 0])
set(H, 'XColor', [1 1 1])
set(H, 'YColor', [1 1 1])
set(H, 'FontAngle', 'italic'); set(H, 'FontSize', 14);

H_X = xlabel(H, 'DPI');
H_Y = ylabel(H, 'Visual Angle (degree)');
set(H_X, 'Color', [1 1 1]); set(H_X, 'FontAngle', 'italic'); set(H_X, 'FontSize', 18); set(H_X, 'FontWeight', 'Demi');
set(H_Y, 'Color', [1 1 1]); set(H_Y, 'FontAngle', 'italic'); set(H_Y, 'FontSize', 18); set(H_Y, 'FontWeight', 'Demi');
set(H_T, 'Color', [1 1 1]); set(H_T, 'FontAngle', 'italic'); set(H_T, 'FontSize', 18); set(H_T, 'FontWeight', 'Demi');

hold off;

