function [res1 res2] = myresize(orig1, orig2)
%% LCM way
%     [m0 n0 f] = size(orig1);
%     [m1 n1 f] = size(orig2);
%     m = lcm(m0, m1); n = lcm(n0, n1);
%     res1 = zeros(m,n,3); res2 = res1;
%     for i = 1:3
%          res1(:,:,i) = ppp(orig1(:,:,i), m,n);
%          res2(:,:,i) = ppp(orig2(:,:,i), m,n);
%     end

%% some other way
    [res1 res2] = preSCIELAB(orig1, orig2);
    res1 = reshape(res1, size(res1,1), size(res1,2)/3, 3);
    res2 = reshape(res2, size(res2,1), size(res2,2)/3, 3);
end

%% function for LCM
function res = ppp(a, m, n)
    [p q] = size(a);
    res = [];
    for i = 1:p
        tmp = [];
        for j = 1:q
            tmp = [tmp a(i,j) * ones(m/p, n/q)];
        end
        res = [res; tmp];
    end
end