% Script to demonstrate the use of a space-invariant Gaussian PSF
%
% This script creates a scene with a point array.
%
% The scene is transformed using diffraction limited methods
% (shift-invariant).  The diffraction limited methods use the f# and focal
% length.
%
% The an default sensor is used to capture the image, subsequently the
% pixels of this sensor are reduced in size.
%
% Peter Catrysse (03-10-2006)

clear all

wave = [400:10:700];
nWaves = length(wave);

% Create scene point array or Macbeth
%
% scene = sceneCreate('pointArray',128,32);
% scene = sceneSet(scene,'name','psfPointArray');
% scene = sceneInterpolateW(scene,wave);
% scene = sceneSet(scene,'hfov',1);
scene = sceneCreate('macbethd65',64);
scene = sceneSet(scene,'name','Macbeth D65');
scene = sceneInterpolateW(scene,wave);
scene = sceneSet(scene,'hfov',3);

perform_radial_blur=1;
if (perform_radial_blur == 1)
    scene.data.photons = blurSPDs(scene.data.photons,scene.spectrum.wave,1.5);
end

vcAddAndSelectObject('scene',scene); sceneWindow;



% Create optical image
%
oi = oiCreate;
oi = oiSet(oi,'spectrum',sceneGet(scene,'spectrum'));

% Calculate Gaussian PSF with given blur (in units of um)
%
psfType = 'gaussian'; psfBlur = 1.0;
psfRatio = 3*ones(1,nWaves);
waveSpread = wave/wave(1)*psfBlur;
optics = siSynthetic(oi,waveSpread,psfType,psfRatio);
optics = opticsSet(optics,'model','shiftinvariant');

% Attach optics to optical image
%
oi = oiSet(oi,'optics',optics);
oi = oiCompute(scene,oi);
vcAddAndSelectObject('oi',oi); oiWindow;


% Create default sensor with 2.8 um pixels
%
sensor = sensorCreate;
sensor = sensorCompute(sensor,oi);


sensor_model_to_use = 2;
if (sensor_model_to_use == 1)
    % Create default sensor with 2.8 um pixels
    %
    vcAddAndSelectObject('sensor',sensor); sensorImageWindow;
else
    % Or make one with smaller 1.4 um pixels
    pixel = sensorGet(sensor,'pixel');
    pixel = pixelSet(pixel,'sizesamefillfactor',[1.4 1.4]*1e-6);
    sensor = sensorSet(sensor,'pixel',pixel);
    sensor = sensorCompute(sensor,oi);
    vcAddAndSelectObject('sensor',sensor); sensorImageWindow;
end

sensorCCM;