function imgout=gaussblur(imgin, sigma);

    tail_precision = 4;
    padding = round(tail_precision*2*sigma);
    
    num_rows = size(imgin,1);
    num_cols = size(imgin,2);
    
    %
    % X-DIRECTION BLURRING
    %
    
    % pad image to allow convolution overflow...will be cropped out at end
    imgout = zeros(size(imgin,1),size(imgin,2)+2*padding);
    
    for col=1:num_cols
        xdist = 2 * abs(round(col - num_cols/2)) / num_cols;
        curr_sigma = xdist*sigma;
        
        if (curr_sigma ~= 0)        
            support = -round(tail_precision*curr_sigma) : round(tail_precision*curr_sigma);
            
            gauss2D = exp( - (support / curr_sigma).^2 / 2);
            gauss2D = gauss2D / sum(gauss2D); % normalize to area of 1
            gauss2D = gauss2D((length(gauss2D)+1)/2)*gauss2D; % intensity falloff...use Gaussian peak as scaling factor
            
            imgout(:,support+col+padding) = imgout(:,support+col+padding) + conv2(imgin(:,col),gauss2D);
        else
            imgout(:,col+padding) = imgout(:,col+padding) + imgin(:,col);
        end
    end
    
    % crop out extra padding
    imgout = imgout(:,1+padding:size(imgin,2)+padding);
    
    
    imgin = imgout;
    
    
    %
    % Y-DIRECTION BLURRING
    %    
    
    % pad image to allow convolution overflow...will be cropped out at end
    imgout = zeros(size(imgin,1)+2*padding,size(imgin,2));
    
    for row=1:num_rows
        ydist = 2 * abs(round(row - num_rows/2)) / num_rows;
        curr_sigma = ydist*sigma;

        if (curr_sigma ~= 0)
            support = -round(tail_precision*curr_sigma) : round(tail_precision*curr_sigma);
            
            gauss2D = exp( - (support / curr_sigma).^2 / 2);
            gauss2D = gauss2D / sum(gauss2D); % normalize to area of 1
            gauss2D = gauss2D((length(gauss2D)+1)/2)*gauss2D; % intensity falloff...use Gaussian peak as scaling factor
            
            imgout(support+row+padding,:) = imgout(support+row+padding,:) + conv2(imgin(row,:),gauss2D');
        else
            imgout(row+padding,:) = imgout(row+padding,:) + imgin(row,:);
        end
    end

    % crop out extra padding
    imgout = imgout(1+padding:size(imgin,1)+padding,:);

 