
function newImSPD = blurSPDs(imSPD,spectrum,blurfactor)

    %imSPD = vcSESSION.SCENE{1,2}.data.photons;
    %spectrum = vcSESSION.SCENE{1,2}.spectrum.wave;
    
    imSPD = double(imSPD);
    
    % Just init...data will be overwritten
    newImSPD = imSPD;

    for iwavelength=1:size(imSPD,3)
        tic
        wavelength = spectrum(iwavelength);
        fprintf('wavelength = %d\n', wavelength);
        % Create intensity "image" for current wavelength
        wavelengthIm = imSPD(:,:,iwavelength);
        
        tuned_wavelength = 541;

        sigma = (wavelength - tuned_wavelength) / max([abs(400-tuned_wavelength) abs(700-tuned_wavelength)]);
        sigma = abs(sigma);
        %sigma = sigma*sigma;
        
        sigma = blurfactor*sigma;

        
        fprintf('using sigma = %d\n', sigma);
        wavelengthImBlurred = mygaussblur(wavelengthIm,sigma);
        %wavelengthImBlurred = wavelengthIm;

        
        newImSPD(:,:,iwavelength) = wavelengthImBlurred;
        toc
    end
    
    newImSPD = uint16(newImSPD);
    %vcSESSION.SCENE{1,1}.data.photons = newImSPD;