% Author: Preston Chui

% Version: 0.8
% Date Change: 2006-03-14-Tu
% Comment: Print images

% Version: 0.7
% Date Change: 2006-03-11-Sa
% Comment: Include interpolation routine

% Version: 0.6
% Date Change: 2006-03-11-Sa
% Comment: Apply localized radial greyworld (comparison: w blur, wo blur,
% full image gw)

% Version: 0.5
% Date Change: 2006-03-08-We
% Comment: Manhattan distance - change to create mask, two greyworlds: full
% image mean, vs mask mean

% Version: 0.4
% Date Change: 2006-03-08-We
% Comment: Manhattan distance work

% Version: 0.3
% Date Change: 2006-03-08-We
% Comment: Bug fix for gaussian blur application

% Version: 0.2
% Date Change: 2006-02-28-Tu
% Comment: Bug fix for subsectioning code; moved transforms to functions

% Version: 0.1
% Date Change: 2006-02-27-Mo
% Comment: Original-Does rectangular colour balancing, full image colour
% balancing


function kernel_driver(imgorigfile,imgfile)

% choose a pair of test images

imgorig = double(imread(imgorigfile));
img = double(imread(imgfile));


% or choose a pair of overriding test images

% imgorig = double(imread('uniform_orig.tif'));
% img = double(imread('uniform_intensitydrop.tif'));

% imgorig = double(imread('skismall-original.png'));
% img = double(imread('skismall-distorted.png'));

% imgorig = double(imread('grid-original.png'));
% img = double(imread('grid-distorted3.png'));

% imgorig = double(imread('grid-original.png'));
% img = double(imread('grid-original.png'));

% imgorig = double(imread('trees-orig.jpg'));
% img = double(imread('trees-aberration.jpg'));

%---------------------------------------------------------------------

% plot image statistics

figure;
imgrhist = hist(img(:,:,1),256); 
imgghist = hist(img(:,:,2),256); 
imgbhist = hist(img(:,:,3),256); 
subplot(4,1,1); plot(imgrhist); axis([0 256 0 max([max(imgrhist) max(imgghist) max(imgbhist)])]); title('Red');
subplot(4,1,2); plot(imgghist); axis([0 256 0 max([max(imgrhist) max(imgghist) max(imgbhist)])]); title('Green');
subplot(4,1,3); plot(imgbhist); axis([0 256 0 max([max(imgrhist) max(imgghist) max(imgbhist)])]); title('Blue');

imgbw = double(rgb2gray(uint8(img)));
%imshow(uint8(round(imgbw)));
subplot(4,1,4); imgbwhist = hist(imgbw(:),256); plot(imgbwhist); axis([0 256 0 max(max(imgbwhist))]); title('Grey');

%imgbwhist = hist(imgbw(:),256);

figure;
imshow(uint8(img)); title('original');

%---------------------------------------------------------------------

% Global Gray World
mask = ones(size(img,1),size(img,2));
tic
'gw - full image mean - full image'
maskout = greyworldmaskavgmulmaskpixmask(img,mask);
toc
imgout = applymask(img, maskout);

figure;
imshow(uint8(imgout)); title('gw - full image mean - full image');

imgglobalgw = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*5); title('imgglobalgw-diff');

imwrite(uint8(imgdiff)*9,'imgglobalgw-diff.png');

imwrite(uint8(imgglobalgw),'imgglobalgw.png');

lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imgglobalgw.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

%---------------------------------------------------------------------

% local gw kernel - by grid

tic
'gen iterative mask time:'
sigma = 10;
widthfactor = 10;
centerx = floor(size(img,2)/2);
centery = floor(size(img,1)/2);
imgout = img;
cummask = ones(size(img,1),size(img,2),3); % initialize identity mask (all ones)
%blurmask = ones(size(img,1),size(img,2),3);

xincr = ceil(size(img,1)/8);
yincr = ceil(size(img,2)/8);


% globalmask = ones(size(img,1),size(img,2));
% gwlocalkernel = gwlocal(img, globalmask);

% for dist=0:distincr:floor(max(size(img,1)/2,size(img,2)/2)*sqrt(2)/distincr)*distincr+distincr*3
for xstart=1:xincr:size(img,1)
    for ystart=1:yincr:size(img,2)
        mask = zeros(size(img,1),size(img,2));
        if xstart+xincr-1 < size(img,1)
            xend = xstart+xincr-1;
        else
            xend = size(img,1);
        end
        
        if ystart+yincr-1 < size(img,2)
            yend = ystart+yincr-1;
        else
            yend = size(img,2);
        end

        mask(xstart:xend, ystart:yend) = 1;

        gwlocalkernel = gwlocal(img, mask);
        %    maskout=greyworldmaskavgmulmaskpixmask(img,mask);
        maskout=applykernel2mask(img,gwlocalkernel,mask);

        % accumulate mask factors (requires that each mask be disjoint from
        % previous to avoid multiple scalings)
        cummask = maskout .* cummask; 
        %    blurmask(find(mask==1),:) = maskout(find(mask==1),:);

    end
end

whos mask
whos maskout
whos blurmask

blurmask = cummask;
% blurmask(:,:,1)=gaussblur(maskout(:,:,1), sigma, widthfactor);
% blurmask(:,:,2)=gaussblur(maskout(:,:,2), sigma, widthfactor);
% blurmask(:,:,3)=gaussblur(maskout(:,:,3), sigma, widthfactor);
imgout = applymask(img, blurmask);
toc

figure;
imshow(uint8(imgout)); title('gw - grid local mask mean');

imggridlocalnoblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imggridlocalnoblur-diff');

imwrite(uint8(imgdiff)*9,'imggridlocalnoblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imggridlocalnoblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imggridlocalnoblur),'imggridlocalnoblur.png');

tic
'blur time:'
blurmask(:,:,1)=gaussblur(cummask(:,:,1), sigma, widthfactor);
blurmask(:,:,2)=gaussblur(cummask(:,:,2), sigma, widthfactor);
blurmask(:,:,3)=gaussblur(cummask(:,:,3), sigma, widthfactor);
toc

imgout = applymask(img, blurmask);

figure;
imshow(uint8(imgout)); title('gw - grid local mask mean - blur');

imggridlocalblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imggridlocalblur-diff');

imwrite(uint8(imgdiff)*9,'imggridlocalblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imggridlocalblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imggridlocalblur),'imggridlocalblur.png');



%---------------------------------------------------------------------

% iterate over entire image over all distances using local gw kernel (no
% interpolation) - large distincr

tic
'gen iterative mask time:'
sigma = 10;
widthfactor = 10;
centerx = floor(size(img,2)/2);
centery = floor(size(img,1)/2);
distincr=50;
imgout = img;
cummask = ones(size(img,1),size(img,2),3); % initialize identity mask (all ones)
%blurmask = ones(size(img,1),size(img,2),3);


% globalmask = ones(size(img,1),size(img,2));
% gwlocalkernel = gwlocal(img, globalmask);

% for dist=0:distincr:floor(max(size(img,1)/2,size(img,2)/2)*sqrt(2)/distincr)*distincr+distincr*3
for dist=0:distincr:floor((size(img,1)/2+size(img,2)/2)/distincr)*distincr+distincr
    mask = getequidistpix(img, centerx, centery, dist, dist+distincr-1);

    gwlocalkernel = gwlocal(img, mask);
    %    maskout=greyworldmaskavgmulmaskpixmask(img,mask);
    maskout=applykernel2mask(img,gwlocalkernel,mask);
    
    % accumulate mask factors (requires that each mask be disjoint from
    % previous to avoid multiple scalings)
    cummask = maskout .* cummask; 
    %    blurmask(find(mask==1),:) = maskout(find(mask==1),:);
end

whos mask
whos maskout
whos blurmask

blurmask = cummask;
% blurmask(:,:,1)=gaussblur(maskout(:,:,1), sigma, widthfactor);
% blurmask(:,:,2)=gaussblur(maskout(:,:,2), sigma, widthfactor);
% blurmask(:,:,3)=gaussblur(maskout(:,:,3), sigma, widthfactor);
imgout = applymask(img, blurmask);
toc

figure;
imshow(uint8(imgout)); title('gw - local mask mean (large incr) - multiple ranges to edge');

imglocalbigstepnoblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imglocalbigstepnoblur-diff');

imwrite(uint8(imgdiff)*9,'imglocalbigstepnoblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imglocalbigstepnoblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imglocalbigstepnoblur),'imglocalbigstepnoblur.png');

tic
'blur time:'
blurmask(:,:,1)=gaussblur(cummask(:,:,1), sigma, widthfactor);
blurmask(:,:,2)=gaussblur(cummask(:,:,2), sigma, widthfactor);
blurmask(:,:,3)=gaussblur(cummask(:,:,3), sigma, widthfactor);
toc

imgout = applymask(img, blurmask);

figure;
imshow(uint8(imgout)); title('gw - local mask mean (large incr) - multiple ranges to edge with blurring');

imglocalbigstepblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imglocalbigstepblur-diff');

imwrite(uint8(imgdiff)*9,'imglocalbigstepblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imglocalbigstepblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imglocalbigstepblur),'imglocalbigstepblur.png');


%---------------------------------------------------------------------

% iterate over entire image over all distances using local gw kernel (no
% interpolation) - small distincr

tic
'gen iterative mask time:'
sigma = 10;
widthfactor = 10;
centerx = floor(size(img,2)/2);
centery = floor(size(img,1)/2);
distincr=1;
imgout = img;
cummask = ones(size(img,1),size(img,2),3); % initialize identity mask (all ones)
%blurmask = ones(size(img,1),size(img,2),3);


% globalmask = ones(size(img,1),size(img,2));
% gwlocalkernel = gwlocal(img, globalmask);

% for dist=0:distincr:floor(max(size(img,1)/2,size(img,2)/2)*sqrt(2)/distincr)*distincr+distincr*3
for dist=0:distincr:floor((size(img,1)/2+size(img,2)/2)/distincr)*distincr+distincr
    mask = getequidistpix(img, centerx, centery, dist, dist+distincr-1);

    gwlocalkernel = gwlocal(img, mask);
    %    maskout=greyworldmaskavgmulmaskpixmask(img,mask);
    maskout=applykernel2mask(img,gwlocalkernel,mask);
    
    % accumulate mask factors (requires that each mask be disjoint from
    % previous to avoid multiple scalings)
    cummask = maskout .* cummask; 
    %    blurmask(find(mask==1),:) = maskout(find(mask==1),:);
end

whos mask
whos maskout
whos blurmask

blurmask = cummask;
% blurmask(:,:,1)=gaussblur(maskout(:,:,1), sigma, widthfactor);
% blurmask(:,:,2)=gaussblur(maskout(:,:,2), sigma, widthfactor);
% blurmask(:,:,3)=gaussblur(maskout(:,:,3), sigma, widthfactor);
imgout = applymask(img, blurmask);
toc

figure;
imshow(uint8(imgout)); title('gw - local mask mean (small incr) - multiple ranges to edge');

imglocalsmallstepnoblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imglocalsmallstepnoblur-diff');

imwrite(uint8(imgdiff)*9,'imglocalsmallstepnoblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imglocalsmallstepnoblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imglocalsmallstepnoblur),'imglocalsmallstepnoblur.png');

tic
'blur time:'
blurmask(:,:,1)=gaussblur(cummask(:,:,1), sigma, widthfactor);
blurmask(:,:,2)=gaussblur(cummask(:,:,2), sigma, widthfactor);
blurmask(:,:,3)=gaussblur(cummask(:,:,3), sigma, widthfactor);
toc

imgout = applymask(img, blurmask);

figure;
imshow(uint8(imgout)); title('gw - local mask mean (small incr) - multiple ranges to edge with blurring');

imglocalsmallstepblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imglocalsmallstepblur-diff');

imwrite(uint8(imgdiff)*9,'imglocalsmallstepblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imglocalsmallstepblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imglocalsmallstepblur),'imglocalsmallstepblur.png');


%---------------------------------------------------------------------

% interpolate intermediate kernels using local gw kernel for pre- and post-
% zones


tic
'gen iterative mask time:'
sigma = 10;
widthfactor = 10;
centerx = floor(size(img,2)/2);
centery = floor(size(img,1)/2);
distincr=50;
intrpincr=1;
imgout = img;
cummask = ones(size(img,1),size(img,2),3); % initialize identity mask (all ones)
%blurmask = ones(size(img,1),size(img,2),3);


for dist=0:distincr:floor((size(img,1)/2+size(img,2)/2)/distincr)*distincr+distincr
    postmask  = getequidistpix(img, centerx, centery, dist, dist+distincr-1);
    if dist-distincr >= 0
        premask = getequidistpix(img, centerx, centery, dist-distincr, dist-1);
    else 
        premask = getequidistpix(img, centerx, centery, 0, distincr-1);
    end

    gwprekernel  = gwlocal(img, premask);
    gwpostkernel = gwlocal(img, postmask);

    %    maskout=greyworldmaskavgmulmaskpixmask(img,mask);
    
    dstart = dist-floor(distincr/2);
    dend   = dist+floor(distincr/2)-1;
    for d=dstart:intrpincr:dend
        mask = getequidistpix(img, centerx, centery, d, d+intrpincr-1);

        maskout=applykernel2mask(img,(gwpostkernel-gwprekernel)/(dend-dstart)*(d-dstart)+gwprekernel,mask);
    
        % accumulate mask factors (requires that each mask be disjoint from
        % previous to avoid multiple scalings)
        cummask = maskout .* cummask; 
        %    blurmask(find(mask==1),:) = maskout(find(mask==1),:);

    end
end

whos mask
whos maskout
whos blurmask

blurmask = cummask;
% blurmask(:,:,1)=gaussblur(maskout(:,:,1), sigma, widthfactor);
% blurmask(:,:,2)=gaussblur(maskout(:,:,2), sigma, widthfactor);
% blurmask(:,:,3)=gaussblur(maskout(:,:,3), sigma, widthfactor);
imgout = applymask(img, blurmask);
toc

figure;
imshow(uint8(imgout)); title('gw - local mask mean (pre,post) - single step interpolation');

imginterpnoblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imginterpnoblur-diff');

imwrite(uint8(imgdiff)*9,'imginterpnoblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imginterpnoblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imginterpnoblur),'imginterpnoblur.png');

tic
'blur time:'
blurmask(:,:,1)=gaussblur(cummask(:,:,1), sigma, widthfactor);
blurmask(:,:,2)=gaussblur(cummask(:,:,2), sigma, widthfactor);
blurmask(:,:,3)=gaussblur(cummask(:,:,3), sigma, widthfactor);
toc

imgout = applymask(img, blurmask);

figure;
imshow(uint8(imgout)); title('gw - local mask mean (pre,post) - single step interpolation with blurring');

imginterpblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imginterpblur-diff');

imwrite(uint8(imgdiff)*9,'imginterpblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imginterpblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imginterpblur),'imginterpblur.png');

%---------------------------------------------------------------------

% interpolate intermediate kernels using local gw kernel for pre- and post-
% zones
% average each local kernel with global gw kernel

tic
'gen iterative mask time:'
sigma = 10;
widthfactor = 10;
centerx = floor(size(img,2)/2);
centery = floor(size(img,1)/2);
distincr=50;
intrpincr=1;
imgout = img;
cummask = ones(size(img,1),size(img,2),3); % initialize identity mask (all ones)
%blurmask = ones(size(img,1),size(img,2),3);

globalmask = ones(size(img,1),size(img,2));
gwglobalkernel = gwlocal(img, globalmask);

for dist=0:distincr:floor((size(img,1)/2+size(img,2)/2)/distincr)*distincr+distincr
    postmask  = getequidistpix(img, centerx, centery, dist, dist+distincr-1);
    if dist-distincr >= 0
        premask = getequidistpix(img, centerx, centery, dist-distincr, dist-1);
    else 
        premask = getequidistpix(img, centerx, centery, 0, distincr-1);
    end
            
    gwprekernel  = gwlocal(img, premask);
    gwpostkernel = gwlocal(img, postmask);
    
    %average with global kernel
    gwprekernel = (gwglobalkernel + gwprekernel)/2;
    gwpostkernel = (gwglobalkernel + gwpostkernel)/2;

    %    maskout=greyworldmaskavgmulmaskpixmask(img,mask);
    
    dstart = dist-floor(distincr/2);
    dend   = dist+floor(distincr/2)-1;
    for d=dstart:intrpincr:dend
        mask = getequidistpix(img, centerx, centery, d, d+intrpincr-1);

        maskout=applykernel2mask(img,(gwpostkernel-gwprekernel)/(dend-dstart)*(d-dstart)+gwprekernel,mask);
    
        % accumulate mask factors (requires that each mask be disjoint from
        % previous to avoid multiple scalings)
        cummask = maskout .* cummask; 
        %    blurmask(find(mask==1),:) = maskout(find(mask==1),:);

    end
end

whos mask
whos maskout
whos blurmask

blurmask = cummask;
% blurmask(:,:,1)=gaussblur(maskout(:,:,1), sigma, widthfactor);
% blurmask(:,:,2)=gaussblur(maskout(:,:,2), sigma, widthfactor);
% blurmask(:,:,3)=gaussblur(maskout(:,:,3), sigma, widthfactor);
imgout = applymask(img, blurmask);
toc

figure;
imshow(uint8(imgout)); title('gw - average of global and local mask mean (pre,post) - single step interpolation');

imgavggloblocinterpnoblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imgavggloblocinterpnoblur-diff');

imwrite(uint8(imgdiff)*9,'imgavggloblocinterpnoblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imgavggloblocinterpnoblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imgavggloblocinterpnoblur),'imgavggloblocinterpnoblur.png');

tic
'blur time:'
blurmask(:,:,1)=gaussblur(cummask(:,:,1), sigma, widthfactor);
blurmask(:,:,2)=gaussblur(cummask(:,:,2), sigma, widthfactor);
blurmask(:,:,3)=gaussblur(cummask(:,:,3), sigma, widthfactor);
toc

imgout = applymask(img, blurmask);

figure;
imshow(uint8(imgout)); title('gw - average of global and local mask mean (pre,post) - single step interpolation with blurring');

imgavggloblocinterpblur = imgout;

figure;
imgdiff = imgout-imgorig;
imshow(uint8(imgdiff)*9); title('imgavggloblocinterpblur-diff');

imwrite(uint8(imgdiff)*9,'imgavggloblocinterpblur-diff.png');
lsm = mean(mean(mean(imgdiff.^2)));
file_name = 'imgavggloblocinterpblur.txt'
file_id = fopen(file_name,'w');
fprintf(file_id,'%s %8.2f', file_name, lsm)
fclose(file_id);

imwrite(uint8(imgavggloblocinterpblur),'imgavggloblocinterpblur.png');

%---------------------------------------------------------------------


