% Author: Preston Chui

% Version: 0.3
% Date Change: 2006-03-11-Sa
% Comment: Rewritten: functionality was wrong: didn't account for matrices
% without zeros on non-diagonal elements in kernel

% Version: 0.2
% Date Change: 2006-03-11-Sa
% Comment: Fast, only applies transform to elements of mask that are set active

% Version: 0.1
% Date Change: 2006-03-11-Sa
% Comment: Slow, applies to every element regardless of mask

%---------------------------------------------------------------------

function kernel = gwlocal(img, mask)
% take img, and for given mask, find greyworld kernel matrix for those masked
% img pixels 

% image should be in height:width:3 format (RGB)
% input: img: RGB (l*w*3), mask: RGB (l*w*1)
% output: kernel: 3x3


% reshape image such that each pixel is located in the ith entry of imdata vector, in 3 value vector
% img and mask dimensions in first 2D should be identical
imgvec = reshape(img, size(img,1)*size(img,2),3);
maskvec = reshape(mask, size(mask,1)*size(mask,2),1);

% deal with empty masks, return identity kernel
maskvechits = find(maskvec==1);
if size(maskvechits,1)==0
    kernel = [1 0 0; 0 1 0; 0 0 1];
    return
end

imgvecmaskelem=imgvec(maskvechits,:);
imgrgbmean = [mean(imgvecmaskelem(:,1)) mean(imgvecmaskelem(:,2)) mean(imgvecmaskelem(:,3))];
if imgrgbmean(1)==0
    imggrfactor = 1;
else
    imggrfactor = imgrgbmean(2)/imgrgbmean(1);
end
imgggfactor = 1;
if imgrgbmean(3)==0
    imggbfactor = 1;
else
    imggbfactor = imgrgbmean(2)/imgrgbmean(3);
end

kernel = [...
          imggrfactor 0 0;...
          0 imgggfactor 0;...
          0 0 imggbfactor;...
          ];
      
