% Author: Preston Chui

% Version: 0.3
% Date Change: 2006-03-11-Sa
% Comment: Rewritten: functionality was wrong: didn't account for matrices
% without zeros on non-diagonal elements in kernel

% Version: 0.2
% Date Change: 2006-03-11-Sa
% Comment: Fast, only applies transform to elements of mask that are set active

% Version: 0.1
% Date Change: 2006-03-11-Sa
% Comment: Slow, applies to every element regardless of mask

%---------------------------------------------------------------------

function maskout = greyworldmaskavgmulmaskpixmask(img, mask)
% take img, and for given mask, find greyworld matrix for those masked
% img pixels and output a mask that has greyworld matrix at masked elements
% and ones everywhere else

% image should be in height:width:3 format (RGB)
% input: img: RGB (l*w*3), mask: RGB (l*w*1)
% output: RGB (l*w*3)
% kernel: 3x3


% reshape image such that each pixel is located in the ith entry of imdata vector, in 3 value vector
% img and mask dimensions in first 2D should be identical
imgvec = reshape(img, size(img,1)*size(img,2),3);
maskvec = reshape(mask, size(mask,1)*size(mask,2),1);
maskoutvec = ones(size(mask,1)*size(mask,2),3);


imgmask=imgvec(find(maskvec==1),:);
imgrgbmean = mean(imgmask);
imggrfactor = imgrgbmean(2)/imgrgbmean(1);
imgggfactor = 1;
imggbfactor = imgrgbmean(2)/imgrgbmean(3);

kernel = [...
          imggrfactor 0 0;...
          0 imgggfactor 0;...
          0 0 imggbfactor;...
          ];
      
kernel

% hack: make all img elements that are zero into one to keep from dividing
% by zero
imgvec(find(imgvec==0)) = 1;

maskvecelem = find(maskvec(:)==1);
maskoutvec(maskvecelem,:) = ( (kernel*imgvec(maskvecelem,:)')./imgvec(maskvecelem,:)' )';


% for i=1:size(maskdata,1)
%     maskout(i,:)=onedata(i,:)*(kernel^maskdata(i));
% end

% reshape into image form
maskout = reshape(maskoutvec,size(mask,1),size(mask,2),3);

% imshow(uint8(maskout));
