function mask = getequidistpix(img, centerx, centery, diststart, distend);
% return a mask (active high) of those pixels equidistant (by manhattan distance) from the
% specified center point

% centerx=floor(size(img,2)/2);
% centery=floor(size(img,1)/2);
% diststart=50;
% distend=100;

mask = zeros(size(img, 1),size(img, 2));

for dist = diststart:distend

    for x = -dist:dist
        tgtx = centerx+x;
        tgty = centery+(dist-abs(x));
        if tgtx>=1 && tgty>=1 && tgtx<=size(img,2) && tgty<=size(img,1)
            mask(tgty, tgtx)=1;
        end

        tgtx = centerx+x;
        tgty = centery-(dist-abs(x));
        if tgtx>=1 && tgty>=1 && tgtx<=size(img,2) && tgty<=size(img,1)
            mask(tgty, tgtx)=1;
        end
    end

end

% figure;
% imshow(double(mask)); title('inner mask');

