
function imgout=gaussblur(imgin, sigma, widthfactor);
% function: blurring
% input: greyscale (l*w*1)
% output: greyscale (l*w*1)
% ok results: sigma 20 width 20

width = widthfactor * sigma;
support = -width : width;
gauss2D = exp( - (support / sigma).^2 / 2); 
gauss2D = gauss2D / sum(gauss2D);
imgout = conv2(conv2(imgin, gauss2D, 'same'), gauss2D', 'same');

