% Author: Preston Chui

% Version: 0.2
% Date Change: 2006-03-11-Sa
% Comment: Fast, only applies transform to elements of mask that are set active

% Version: 0.1
% Date Change: 2006-03-11-Sa
% Comment: Slow, applies to every element regardless of mask

%---------------------------------------------------------------------

function maskout = applykernel2mask(img, kernel, mask)
% take img, and for given mask, return a maskout that contains the factors
% by which the img pixel RGB values would change given the kernel

% image should be in height:width:3 format (RGB)
% input: img: RGB (l*w*3), mask: RGB (l*w*1), kernel: 3x3
% output: maskout: RGB (l*w*3)


% reshape
imgvec = reshape(img, size(img,1)*size(img,2),3);
maskvec = reshape(mask, size(mask,1)*size(mask,2),1);
maskoutvec = ones(size(mask,1)*size(mask,2),3);

kernel

% hack: make all img elements that are zero into one to keep from dividing
% by zero
imgvec(find(imgvec==0)) = 1;

maskvecelem = find(maskvec(:)==1);
maskoutvec(maskvecelem,:) = ( (kernel*imgvec(maskvecelem,:)')./imgvec(maskvecelem,:)' )';

% reshape into image form
maskout = reshape(maskoutvec,size(mask,1),size(mask,2),3);

