% Steganalysis utility for Spread Spectrum watermarking
% Input:  res = 512x512 3 channel watermarked image
%         original = original image, for comparison
%         wmark = watermark used
%         a = power constant

original2 = original;

% choose this to test image resizing
original2 = imresize(imresize(original2, .5, 'bilinear'), 2, 'bilinear');

% choose this to test jpeg compression
%imwrite(double(original2) ./ 256, 'test.jpg', 'jpeg', 'Quality', 10);
%original2 = imread('test.jpg', 'jpg');

% Extract Y channel from original image
r = double(original2(:,:,1));
g = double(original2(:,:,2));
b = double(original2(:,:,3));
origY =   0.2990*r + 0.5870*g + 0.1140*b;

% Get DCT of original image
origYd = dct2(origY);
disp('computed DCT of original')

% Extract Y channel from watermarked image
r = double(res(:,:,1));
g = double(res(:,:,2));
b = double(res(:,:,3));
waterimageY =   0.2990*r + 0.5870*g + 0.1140*b;

% Get DCT of watermarked image
waterimageYd = dct2(waterimageY);
disp('computed DCT of watermarked image')

% compute similarity
Wstar = (1/a)*((waterimageYd ./ origYd) - 1);

similarity = zeros(100);
for i=1:100
    originalW = randn(512);
    similarity(i) = sum(sum(originalW .* Wstar)) / sqrt(sum(sum((originalW .* originalW) .* (Wstar .* Wstar))));
end

originalW = wmark;
originalW(1,1) = 0;
similarity(50) = sum(sum(originalW .* Wstar)) / sqrt(sum(sum((originalW .* originalW) .* (Wstar .* Wstar))));
%similarity(50) = sum(originalW .* Wstar) / sqrt(sum((originalW .* originalW) .* (Wstar .* Wstar)));
stem(similarity);
