% A Block Complexity based Data Embedding watermarking alrogithm
% Input: 512x512 3 channel TIFF
% Output: res = 512x512 3 channel watermarked image
%         original = original image, for comparison
%         wmark = watermark used
%         a = power constant

function [res, original, wmark, a] = spread(filename)
lena = imread(filename);
original = lena;

a = .1;

r = double(lena(:,:,1));
g = double(lena(:,:,2));
b = double(lena(:,:,3));

% convert to YCbCr
Y =   0.2990*r + 0.5870*g + 0.1140*b;
Cb = -0.1687*r - 0.3313*g + 0.5000*b;
Cr =  0.5000*r - 0.4187*g - 0.0813*b;
disp('computed ycbcr')

Xd = dct2(Y);
W = randn(512);
mask = findNmax(Xd, 1000);
disp('found mask')

Yd = Xd .* (1+a*(W .* mask));
wmark = W .* mask;

% need to not overwrite the DC component
Yd(1,1) = Xd(1,1);

Y = idct2(Yd);

disp('computed stego image')

% Convert the compressed YCbCr image back into RGB format
r_stego = truncate(Y + 1.4020*Cr,0,255);
g_stego = truncate(Y - 0.3441*Cb - 0.7141*Cr,0,255);
b_stego = truncate(Y     + 1.7720*Cb - 0.0001*Cr,0,255);

res(:,:,1) = r_stego;
res(:,:,2) = g_stego;
res(:,:,3) = b_stego;

figure; imshow(res ./ 256)

% originalW = W .* mask;
% originalW(1,1) = 0;
% %originalW = randn(512);
% Wstar = (1/a)*(Yd - Xd) ./ Xd;
% 
% similarity = sum(originalW .* Wstar) / sqrt(sum((originalW .* originalW) .* (Wstar .* Wstar)))















% lena2 = imresize(res, .5, 'bilinear');
% figure; imshow(uint8(lena2));

%(1/a)*((Yd - Xd) ./ Xd);





% 
% res2 = res / 256;
% res2(192:320, 192:320, 1) = 0;
% res2(192:320, 192:320, 2) = 0;
% res2(192:320, 192:320, 3) = 0;
% figure; imshow(res2 )
% 
% r = double(res2(:,:,1));
% g = double(res2(:,:,2));
% b = double(res2(:,:,3));
% 
% % convert to YCbCr
% Y =   0.2990*r + 0.5870*g + 0.1140*b;
% Cb = -0.1687*r - 0.3313*g + 0.5000*b;
% Cr =  0.5000*r - 0.4187*g - 0.0813*b;
% 
% Yd = dct2(Y);
% 
% originalW = W .* mask;
% originalW(1,1) = 0;
% %originalW = randn(512);
% Wstar = (1/a)*(Yd - Xd) ./ Xd;
% 
% %Xd == origional image DCT'd y component
% %Yd == output image DCT'd y component
% similarity = sum(originalW .* Wstar) / sqrt(sum((originalW .* originalW) .* (Wstar .* Wstar)))
