% Steganalysis utility for IA-DCT watermarking
% Input:  res = 512x512 3 channel watermarked image
%         original = original image, for comparison
%         wmark = watermark used
%         a = power constant
%         J = JND function


original2 = original;

% choose this to test image resizing
%original2 = imresize(imresize(original, .5, 'bilinear'), 2, 'bilinear');

% choose this to test jpeg compression
%imwrite(double(original2) ./ 256, 'test.jpg', 'jpeg', 'Quality', 5);
%original2 = imread('test.jpg', 'jpg');

% Extract Y channel from original image
r = double(original2(:,:,1));
g = double(original2(:,:,2));
b = double(original2(:,:,3));
origY =   0.2990*r + 0.5870*g + 0.1140*b;

% Get DCT of original image
origYd = blkproc(origY, [8 8], @dct2);
disp('computed DCT of original')

% Extract Y channel from watermarked image
r = double(res(:,:,1));
g = double(res(:,:,2));
b = double(res(:,:,3));
waterimageY =   0.2990*r + 0.5870*g + 0.1140*b;

% Get DCT of watermarked image
waterimageYd = blkproc(waterimageY, [8 8], @dct2);
disp('computed DCT of watermarked image')


% compute similarity
similarity = zeros(1, 100);
Wstar = -(origYd - waterimageYd) ./ J;

for i=1:100
    W = randn(512);
    similarity(i) = sum(W .* Wstar) / sqrt(sum((W .* W) .* (Wstar .* Wstar)));
    if mod(i,10)==0
        disp(i)
    end
end
W = new_watermark;
similarity(50) = sum(W .* Wstar) / sqrt(sum((W .* W) .* (Wstar .* Wstar)));
stem(similarity);
