% inputs: original image (512x512 tiff format)
% outputs: res = watermarked image
%          original = original image (needed for extraction)
%          new_watermark = masked watermark data (needed for extraction)
%          J = JND function

function [res, original, new_watermark, J ] = iadct(filename)

% load image
lena = imread(filename);
original = lena;

% Convert to YCbCr
r = double(lena(:,:,1));
g = double(lena(:,:,2));
b = double(lena(:,:,3));

Y =   0.2990*r + 0.5870*g + 0.1140*b;
Cb = -0.1687*r - 0.3313*g + 0.5000*b;
Cr =  0.5000*r - 0.4187*g - 0.0813*b;
origY = Y;
disp('computed ycbcr')


table = jpeg_qtables(100,1);
watermark = randn(512);
J = zeros(512);
Zd = zeros(512);

disp('finished init')

for i=0:63
    for j=0:63
 
        % compute the DCT if the luminance channel
        Xd = dct2(Y(8*i+1:8*i+8, 8*j+1:8*j+8));
        
        % calculate watermark values
        table2 = (table ./ 2) * (Xd(1,1) / 1024) ^ 0.694;
        table3 = (abs(Xd) .^ 0.3) .* (table2 .^ 0.7);
        table3(1,1) = table2(1,1);
        J(8*i+1:8*i+8, 8*j+1:8*j+8) = max(table2, table3);  
        JW = J(8*i+1:8*i+8, 8*j+1:8*j+8) .* watermark(8*i+1:8*i+8, 8*j+1:8*j+8);
        mask = abs(Xd) > max(table2, table3);
        new_watermark(8*i+1:8*i+8, 8*j+1:8*j+8) = mask .* watermark(8*i+1:8*i+8, 8*j+1:8*j+8);

        Yd = Xd + mask .* JW;
        %Zd(8*i+1:8*i+8, 8*j+1:8*j+8) = Yd;
        Y(8*i+1:8*i+8, 8*j+1:8*j+8) = idct2(Yd);            
    end
    i
end

 
 
r_stego = truncate(Y + 1.4020*Cr,0,255);
g_stego = truncate(Y - 0.3441*Cb - 0.7141*Cr,0,255);
b_stego = truncate(Y     + 1.7720*Cb - 0.0001*Cr,0,255);
 
res(:,:,1) = r_stego;
res(:,:,2) = g_stego;
res(:,:,3) = b_stego;
res = round(res);

figure; imshow(res ./ 256);

